/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : move.c                                           */
/* contenu       : deplacement des curseurs                         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "area.h"
#include "autoplay.h"
#include "config.h"
#include "cursor.h"
#include "joystick.h"
#include "keyboard.h"
#include "mesh.h"
#include "mouse.h"
#include "move.h"
#include "time.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int move_if_free (int *x, int *y, int dir)
{
 int moved=0;

 while (dir>8)
    dir-=8;
 while (dir<1)
    dir+=8;

 switch (dir)
  {
   case 1: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)].mesh)
              {
               (*y)--;
               moved=1;
              }
           break;
   case 2: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*y)--;
               (*x)++;
                moved=1;
              }
           break;
   case 3: if (CURRENT_AREA[(*y)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*x)++;
               moved=1;
              }
           break;
   case 4: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)+1].mesh)
              {
               (*x)++;
               (*y)++;
                moved=1;
              }
           break;
   case 5: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)].mesh)
              {
               (*y)++;
               moved=1;
              }
           break;
   case 6: if (CURRENT_AREA[((*y)+1)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*y)++;
               (*x)--;
                moved=1;
              }
           break;
   case 7: if (CURRENT_AREA[(*y)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*x)--;
               moved=1;
              }
           break;
   case 8: if (CURRENT_AREA[((*y)-1)*CURRENT_AREA_W+(*x)-1].mesh)
              {
               (*x)--;
               (*y)--;
               moved=1;
              }
  }
 return moved;
}

/*------------------------------------------------------------------*/
static void move_cursor (int indice)
{
 int dir=0,up,down,right,left,horiz=0,vert=0,moved=0,team;
 char key_state;
 MESH *mesh;

 team=CURRENT_CURSOR[indice].team;
 mesh=CURRENT_AREA [CURRENT_CURSOR[indice].y*CURRENT_AREA_W
                   +CURRENT_CURSOR[indice].x].mesh;
 mesh->info[team].update.time=-1;

 key_state=CURRENT_CURSOR[indice].key_state;

 up=key_state&CURSOR_KEY_UP;
 right=key_state&CURSOR_KEY_RIGHT;
 down=key_state&CURSOR_KEY_DOWN;
 left=key_state&CURSOR_KEY_LEFT;

 if ((right&&left) || ((!right)&&(!left)))
    horiz=0;
 if (right&&(!left))
    horiz=1;
 if ((!right)&&left)
    horiz=-1;

 if ((up&&down) || ((!up)&&(!down)))
    vert=0;
 if (up&&(!down))
    vert=-1;
 if ((!up)&&down)
    vert=1;

 if (horiz==0 && vert==0)
    dir=0;
 if (horiz==0 && vert==-1)
    dir=1;
 if (horiz==1 && vert==-1)
    dir=2;
 if (horiz==1 && vert==0)
    dir=3;
 if (horiz==1 && vert==1)
    dir=4;
 if (horiz==0 && vert==1)
    dir=5;
 if (horiz==-1 && vert==1)
    dir=6;
 if (horiz==-1 && vert==0)
    dir=7;
 if (horiz==-1 && vert==-1)
    dir=8;

 if (dir)
    {
    if (!moved)
        moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                            &(CURRENT_CURSOR[indice]).y,
                            dir);
    if (!moved)
        moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                            &(CURRENT_CURSOR[indice]).y,
                            dir-1);
    if (!moved)
        moved=move_if_free (&(CURRENT_CURSOR[indice]).x,
                            &(CURRENT_CURSOR[indice]).y,
                            dir+1);
    }
 if (moved || !(GLOBAL_CLOCK%(NB_DIRS+1)))
    {
     CURRENT_CURSOR[indice].val--;
    }

 mesh=CURRENT_AREA [CURRENT_CURSOR[indice].y*CURRENT_AREA_W
                   +CURRENT_CURSOR[indice].x].mesh;
 mesh->info[team].update.cursor.x=CURRENT_CURSOR[indice].x;
 mesh->info[team].update.cursor.y=CURRENT_CURSOR[indice].y;
}

/*------------------------------------------------------------------*/
static void update_key_local_cursor (int indice)
{
 CURRENT_CURSOR[indice].key_state
  =is_touched_key (CONFIG_KEY_UP[indice]) ? CURSOR_KEY_UP : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_RIGHT[indice]) ? CURSOR_KEY_RIGHT : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_DOWN[indice]) ? CURSOR_KEY_DOWN : 0;
 CURRENT_CURSOR[indice].key_state
 +=is_touched_key (CONFIG_KEY_LEFT[indice]) ? CURSOR_KEY_LEFT : 0;
}

/*------------------------------------------------------------------*/
static void update_key_network_cursor (int indice)
{
 CURRENT_CURSOR[indice].key_state=0;
}

/*------------------------------------------------------------------*/
static void update_key_cpu_cursor (int indice)
{
 CURRENT_CURSOR[indice].key_state
 =get_computer_next_move(indice);
}

/*------------------------------------------------------------------*/
void move_all_cursors (void)
{
 int i,j;

 update_mouse_control();
 my_poll_joystick();

 for (i=0;i<NB_TEAMS;++i)
   if (CURRENT_CURSOR[i].active)
      {
      if (CURRENT_CURSOR[i].cpu_or_human)
          for (j=0; j<=CONFIG_CURSOR_INCREASE_SPEED; ++j)
             {
              if (CURRENT_CURSOR[i].from_network)
                 update_key_network_cursor(i);
              else
                  update_key_cpu_cursor(i);
              move_cursor (i);
             }
      else
          {
           if (CURRENT_CURSOR[i].from_network)
              update_key_network_cursor(i);
           else
               update_key_local_cursor(i);
           for (j=0; j<=CONFIG_CURSOR_INCREASE_SPEED; ++j)
               move_cursor (i);
          }
      }
}




