/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : play.c                                           */
/* contenu       : fonction play du menu principal                  */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "back.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "error.h"
#include "game.h"
#include "gfxmode.h"
#include "palette.h"
#include "play.h"
#include "score.h"
#include "sound.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int play_sequence (void)
{
  char *message;
  int result,retour=0;
  DIALOG d[2];
  DIALOG_PLAYER *dp;

  d[1].proc=0;

  display_back_image ();
  main_message (d,"Get ready!");
  dp=init_dialog (d,0);
  update_dialog (dp);
  shutdown_dialog (dp);

  set_bg_texture_palette (CONFIG_LEVEL_BG);
  set_fg_texture_palette (CONFIG_LEVEL_FG);
  calc_playing_teams ();
  set_playing_teams_palette ();

  if (PLAYING_TEAMS<2)
  {
     free_game_memory();
     error_not_enough_teams();
  }
   else
  {
  if (!(message=init_game()))
    {
     WATER_VOLUME=CONFIG_WATER_VOLUME_GAME;
     my_fade_out ();

     if (need_to_change_mode(CONFIG_GFX_GAME,CONFIG_GFX_MENU,CONFIG_PAGE_FLIP))
		result=set_resolution (CONFIG_GFX_GAME,CONFIG_PAGE_FLIP);

     if (!blank_round())
     {
      my_fade_in ();

      game ();
     }

     free_game_memory();

     WATER_VOLUME=CONFIG_WATER_VOLUME_MENU;

     my_fade_out();
     if (need_to_change_mode(CONFIG_GFX_GAME,CONFIG_GFX_MENU,CONFIG_PAGE_FLIP))
		result=set_resolution (CONFIG_GFX_MENU,0);

     retour=display_scores ();
    }
  else
    {
     free_game_memory();
     error_not_enough_big_data ();
    }
  }

  return retour;
}

