/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : cursor.c                                         */
/* contenu       : placement et initialisation des curseurs         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "army.h"
#include "grad.h"
#include "cursor.h"
#include "mesh.h"
#include "palette.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

CURSOR CURRENT_CURSOR [NB_TEAMS];

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void reset_all_cursor (void)
{
 int i;

 for (i=0;i<NB_TEAMS;++i)
      CURRENT_CURSOR[i].active=0;
}

/*------------------------------------------------------------------*/
static void init_cursor (int index, int team, int x,int y)
{
 CURRENT_CURSOR[index].active=1;
 CURRENT_CURSOR[index].team=team;
 CURRENT_CURSOR[index].x=x;
 CURRENT_CURSOR[index].y=y;
 CURRENT_CURSOR[index].val=AREA_START_GRADIENT/2;
 CURRENT_CURSOR[index].loose_time=-1;
 CURRENT_CURSOR[index].score_order=0;
 CURRENT_CURSOR[index].color_entry
 =128+team*COLORS_PER_TEAM;
}

/*------------------------------------------------------------------*/
void apply_all_cursor (void)
{
 int i,x,y;
 MESH *temp;

 for (i=0;i<NB_TEAMS;++i)
      if (CURRENT_CURSOR[i].active)
         {
          x=CURRENT_CURSOR[i].x;
          y=CURRENT_CURSOR[i].y;
          if ((temp=CURRENT_AREA [y*CURRENT_AREA_W+x].mesh)!=NULL)
             temp->info[CURRENT_CURSOR[i].team].state.grad
             =CURRENT_CURSOR[i].val;
         }
}

/*------------------------------------------------------------------*/
void auto_cursor (int index, int team)
{
 int i,x,y,x_min,x_max,y_min,y_max,ok,x0,y0,n;

 x=y=n=0;
 for (i=0;i<CURRENT_ARMY_SIZE;++i)
     if (CURRENT_ARMY[i].team==team)
        {
         x+=CURRENT_ARMY[i].x;
         y+=CURRENT_ARMY[i].y;
         n++;
        }

 x0=x_max=x_min=(x/=n);
 y0=y_max=y_min=(y/=n);

 ok=0;
 while (!ok)
       {
       for (x=x_min; x<=x_max && !ok; ++x)
           if (CURRENT_AREA[y*CURRENT_AREA_W+x].mesh!=NULL)
              {
               ok=1;
               x0=x;
               y0=y;
              }
       if (x_max<CURRENT_AREA_W-1)
          ++x_max;

       for (y=y_min; y<=y_max && !ok; ++y)
           if (CURRENT_AREA[y*CURRENT_AREA_W+x].mesh!=NULL)
              {
               ok=1;
               x0=x;
               y0=y;
              }
       if (y_max<CURRENT_AREA_H-1)
          ++y_max;
       for (x=x_max; x>=x_min && !ok; --x)
           if (CURRENT_AREA[y*CURRENT_AREA_W+x].mesh!=NULL)
              {
               ok=1;
               x0=x;
               y0=y;
              }
       if (x_min>0)
          --x_min;
       for (y=y_max; y>=y_min && !ok; --y)
           if (CURRENT_AREA[y*CURRENT_AREA_W+x].mesh!=NULL)
              {
               ok=1;
               x0=x;
               y0=y;
              }
       if (y_min>0)
          --y_min;
       }

   init_cursor (index,team,x0,y0);
}



