/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : graphics.c                                       */
/* contenu       : choix des options graphiques                     */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "gfxmode.h"
#include "graphics.h"
#include "help.h"
#include "menu.h"
#include "sound.h"
#include "wave.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static char *get_page_flip_str(void)
{
 if (CONFIG_PAGE_FLIP)
    return ("On");
 else
     return ("Off");
}

/*------------------------------------------------------------------*/
static int slider_menu_res (void *dp3, int d2)
{
 int *changed;

 play_click ();

 changed=dp3;
 *changed=1;

 my_set_palette ();
 /*     my_fade_in ();*/
 return 0;
}

/*------------------------------------------------------------------*/
static int slider_brightness (void *dp3, int d2)
{
 play_click ();
 CONFIG_BRIGHTNESS=d2;
 my_set_palette ();

 return 0;
}

/*------------------------------------------------------------------*/
int graphic_options (void)
{

/* la gestion des paramtres curseur a ete mise en commentaire...*/

  int menu_res_changed=0;
  DIALOG_PLAYER *dp;
  DIALOG d[18];
  int i,choix=4,retour=0;
  static int y_pos[6]={0,2,3,6,4,5};
  int *temp;

  display_back_image();
  while (retour==0)
        {
         for (i=0; i<6; ++i)
             {
              standard_button (d+i+4,0,y_pos[i],2,9);
              d[i+4].proc=my_textbox_proc;
             }
         for (i=0; i<6; ++i)
             {
              standard_button (d+i+10,1,y_pos[i],2,9);
              d[i+10].proc=my_slider_proc;
             }

         standard_button (d+16,0,8,1,9);
         d[16].dp="Waves";

         quick_buttons(d);
         d[4].dp="Brightness";
         d[5].dp="Menu res";
         d[6].dp="Game res";
         d[7].dp="Viewport size";
         d[8].dp="Fps limit";
         d[9].dp="Page flipping";
         d[10].dp=d[11].dp=d[12].dp=d[13].dp=d[14].dp=d[15].dp=NULL;
#ifdef ALLEGRO_WINDOWS  
         d[11].flags=D_HIDDEN;
#endif
         d[10].d1=16;
         d[11].d1=d[12].d1=4;
         d[13].d1=8;
         d[14].d1=8;
         d[12].dp3=&CONFIG_GFX_GAME;
         d[13].dp3=&CONFIG_VIEWPORT_SIZE;
         d[14].dp3=&CONFIG_FPS_LIMIT;
         for (i=12;i<15;++i)
             {
              d[i].dp=NULL;
              d[i].dp2=slider_int;
              temp=d[i].dp3;
              d[i].d2=*temp;
             }
         d[10].dp=d[11].dp=NULL;
         d[10].d2=CONFIG_BRIGHTNESS;
         d[11].d2=CONFIG_GFX_MENU;
         d[10].dp2=slider_brightness;
         d[11].dp2=slider_menu_res;
         d[11].dp3=&menu_res_changed;

         d[15].proc=my_button_proc;
         d[15].dp=get_page_flip_str();
         d[15].flags=D_EXIT;

         d[17].proc=0;

         if (menu_res_changed)
           {
            menu_res_changed=0;
            display_back_image ();
            dp=init_dialog (d,choix);
            my_fade_in ();
           }
         else
            dp=init_dialog (d,choix);

         show_mouse(screen);
         while ((menu_res_changed==0) && update_dialog (dp))
               ;
         choix=shutdown_dialog (dp);
         if (menu_res_changed)
          {
           if (d[11].d2!=CONFIG_GFX_MENU)
              {
               my_fade_out ();
               if (set_resolution (d[11].d2,0))
                  CONFIG_GFX_MENU=0;
               else
                  CONFIG_GFX_MENU=d[11].d2;
              }
          }
         else
          {
          play_click();
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_GRAPHICS);
                  display_back_image ();
                  break;
             case 15:
                  CONFIG_PAGE_FLIP=CONFIG_PAGE_FLIP ? 0 : 1;
                  d[15].dp=get_page_flip_str();
                  my_button_proc (MSG_DRAW,d+15,0);
                  break;
             case 16:
                  retour=wave_options();
                  display_back_image();
                  break;
             }
          }
        }

  if (retour>0)
    retour--;

 return retour;
}


