/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : army.c                                           */
/* contenu       : placement des armees                             */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "area.h"
#include "army.h"
#include "bigdata.h"
#include "config.h"
#include "cursor.h"
#include "mesh.h"
#include "decal.h"

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

FIGHTER *CURRENT_ARMY=NULL;
int CURRENT_ARMY_SIZE=0;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int get_battle_room (void)
{
 int i,n;

 n=0;
 for (i=0;i<CURRENT_MESH_SIZE;++i)
     n+=CURRENT_MESH[i].side.size
       *CURRENT_MESH[i].side.size;

 return n;
}

/*------------------------------------------------------------------*/
static int add_fighter (FIGHTER *f, int team,
                       int x, int y, int health)
{
 int j;

 j=y*CURRENT_AREA_W+x;

 if (CURRENT_AREA[j].mesh && (!CURRENT_AREA[j].fighter))
    {
       CURRENT_AREA[j].fighter=f;
       f->health=health;
       f->team=team;
       f->x=x;
       f->y=y;
       f->last_dir=j%NB_DIRS;
       return 1;
    }
 else
 return 0;
}

/*------------------------------------------------------------------*/
static void place_team (int part, int team)
{
 int placed,x,y,x_min,y_min,x_max,y_max;
 int fighters;
 int health;
 FIGHTER *pos;

 fighters=CURRENT_ARMY_SIZE/PLAYING_TEAMS;
 ACTIVE_FIGHTERS[team]=0;
/*
 health=fsqrt(fsqrt(1<<CONFIG_FIGHTER_NEW_HEALTH))/4;
 if (health>=MAX_FIGHTER_HEALTH)*/
    health=MAX_FIGHTER_HEALTH-1;

 switch (part)
        {
         case 0 : x=CURRENT_AREA_W/6;
                  y=CURRENT_AREA_H/4;
                  break;
         case 1 : x=CURRENT_AREA_W/2;
                  y=CURRENT_AREA_H/4;
                  break;
         case 2 : x=(5*CURRENT_AREA_W)/6;
                  y=CURRENT_AREA_H/4;
                  break;
         case 3 : x=CURRENT_AREA_W/6;
                  y=(3*CURRENT_AREA_H)/4;
                  break;
         case 4 : x=CURRENT_AREA_W/2;
                  y=(3*CURRENT_AREA_H)/4;
                  break;
         default : x=(5*CURRENT_AREA_W)/6;
                  y=(3*CURRENT_AREA_H)/4;
                  break;
        }
 x_min=x_max=x;
 y_min=y_max=y;

 pos=CURRENT_ARMY+team;
 placed=0;
 while (placed<fighters)
       {
       for (x=x_min; x<=x_max && placed<fighters; ++x)
           placed+=add_fighter
           (pos+placed*PLAYING_TEAMS,team,x,y_min,health);
       if (x_max<CURRENT_AREA_W-2)
          ++x_max;

       for (y=y_min; y<=y_max && placed<fighters; ++y)
           placed+=add_fighter
           (pos+placed*PLAYING_TEAMS,team,x_max,y,health);
       if (y_max<CURRENT_AREA_H-2)
          ++y_max;

       for (x=x_max; x>=x_min && placed<fighters; --x)
           placed+=add_fighter
           (pos+placed*PLAYING_TEAMS,team,x,y_max,health);
       if (x_min>1)
          --x_min;

       for (y=y_max; y>=y_min && placed<fighters; --y)
           placed+=add_fighter
           (pos+placed*PLAYING_TEAMS,team,x_min,y,health);
       if (y_min>1)
          --y_min;
       }
}

/*------------------------------------------------------------------*/
void place_all_team (void)
{
 int i,n;

 n=0;
 for (i=0;i<NB_TEAMS;++i)
        {
         if (CONFIG_TEAM_COLOR[i])
            {
            place_team (i,n);
            auto_cursor (i,n);
            n++;
            }
         else
             ACTIVE_FIGHTERS[n]=0;
        }
}

/*------------------------------------------------------------------*/
void test_army (void)
{
 int i,k,test,x,y;
 FIGHTER f;
 FIGHTER *fp;
 MESH *m;

 for (i=0;i<CURRENT_ARMY_SIZE;++i)
     {
      test=f.team=CURRENT_ARMY[i].team;
      x=f.x=CURRENT_ARMY[i].x;
      y=f.y=CURRENT_ARMY[i].y;
      test=f.health=CURRENT_ARMY[i].health;
      k=y*CURRENT_AREA_W+x;
      fp=CURRENT_AREA[k].fighter;
      m=CURRENT_AREA[k].mesh;
      if (m)
         test=m->info[0].state.grad;
     }
}

/*------------------------------------------------------------------*/
int create_army (void)
{
 int ret=-1,i;

 CURRENT_ARMY_SIZE= (get_battle_room()
                    *(CONFIG_FIGHTER_NUMBER+1))/64;

 CURRENT_ARMY_SIZE/=PLAYING_TEAMS;
 if (CURRENT_ARMY_SIZE<1)
    CURRENT_ARMY_SIZE=1;
 CURRENT_ARMY_SIZE*=PLAYING_TEAMS;
 if ((CURRENT_ARMY
    =malloc_in_big_data_bottom
    (CURRENT_ARMY_SIZE*sizeof (FIGHTER)))!=0)
    {
     for (i=0;i<CURRENT_ARMY_SIZE;++i)
        {
         CURRENT_ARMY[i].team=-1;
         CURRENT_ARMY[i].health=0;
        }
     ret=0;
    }
 return ret;
}

