/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : cursor.h                                         */
/* contenu       : placement et initialisation des curseurs         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_CURSOR
#define LIQUID_WAR_INCLUDE_CURSOR

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "base.h"

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

typedef struct
        {
         int     val;           /* value which will be used when the*/
                                /* will be put into the map. this   */
                                /* value decreases at each round.   */
         int     x;             /* x position of the cursor         */
         int     y;             /* y position of the cursor         */
         int     active;        /* true if the player who owns this */
                                /* cursor is playing with it        */
         int     team;          /* team the cursor belongs to       */
         int     loose_time;    /* time at which this cursor has    */
                                /* lost. it seems that the diff     */
                                /* between cursor and team is not   */
                                /* well defined 8-(                 */
         int     score_order;   /* wether you are 1st or 2nd...     */
         int     color_entry;   /* first color used by this cursor  */
                                /* in the 256 color palette. again  */
                                /* a cursor is associated to a team */
         int     key_state;     /* this value holds the state of all*/
                                /* the keys associated to the cursor*/
                                /* it is a logical or between       */
                                /* - CURSOR_KEY_UP                  */
                                /* - CURSOR_KEY_RIGHT               */
                                /* - CURSOR_KEY_DOWN                */
                                /* - CURSOR_KEY_LEFT                */
                                /* which are defined in move.h      */
         int     cpu_or_human;  /* true if the player is a computer */
         int     from_network;  /* true if the player is located on */
                                /* a remote machine                 */
        } CURSOR;
/*
int ACTIVE_FIGHTER[NB_TEAMS];
int TEAM_COLOR_FIRST_ENTRY[NB_TEAMS];

ces champs ont ete bascules dans la structure curseur
*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

extern CURSOR CURRENT_CURSOR [NB_TEAMS];

/*==================================================================*/
/* fonctions globales                                               */
/*==================================================================*/

void reset_all_cursor (void);
void apply_all_cursor (void);
void auto_cursor (int index, int team);

#endif
