/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : play.c                                           */
/* contenu       : fonction play du menu principal                  */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "back.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "error.h"
#include "game.h"
#include "gfxmode.h"
#include "palette.h"
#include "play.h"
#include "score.h"
#include "sound.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * this function is basically what is launched when one presses
 * the play button. in fact it performs initializations and sanity
 * checks and then launches the game function located in game.c
 */
int play_sequence (void)
{
  char *message;
  int result,retour=0;
  DIALOG d[2];
  DIALOG_PLAYER *dp;

  d[1].proc=0;

  /*
   * we clear the screen by blitting the Liquid War 5 logo
   */
  display_back_image ();
  /*
   * we display a "Get ready!" message so that the user does not worry
   * about what's going on
   */
  main_message (d,"Get ready!");
  /*
   * we call update dialog artificially so that the "Get ready"
   * message is actually blitted on the screen
   */
  dp=init_dialog (d,0);
  update_dialog (dp);
  shutdown_dialog (dp);

  /*
   * we set up the 256 color palette so that it corresponds to
   * the textures the user has chosen
   */
  set_bg_texture_palette (CONFIG_LEVEL_BG);
  set_fg_texture_palette (CONFIG_LEVEL_FG);
  /*
   * we calculate how many teams are playing
   */
  calc_playing_teams ();
  /*
   * we set up the Allegro palette and LW's palette parameters so that
   * an optimized number of colors is used for each team's fighters
   */
  set_playing_teams_palette ();

  /*
   * if there's only one team selected we stop right away and quit
   */
  if (PLAYING_TEAMS<2)
  {
     free_game_memory();
     error_not_enough_teams();
  }
   else
  {
  /*
   * we launch init_game from the game module, this function may fail
   * and if it does it returns a string containing the error message
   */
  if (!(message=init_game()))
    {
     /*
      * we set up the sound of waves a little louder so that the player
      * understands he's playing *now*
      */
     WATER_VOLUME=CONFIG_WATER_VOLUME_GAME;
     /*
      * fade out cause we're going to switch video modes
      */
     my_fade_out ();

     /*
      * we change the resolution, but only if the game resolution is
      * actually different from the menu resolution
      */
     if (need_to_change_mode(CONFIG_GFX_GAME,CONFIG_GFX_MENU,CONFIG_PAGE_FLIP))
		result=set_resolution (CONFIG_GFX_GAME,CONFIG_PAGE_FLIP);

     /*
      * the blank round function initializes the double-buffer system
      * and the main display target, it might fail because of lacking memory
      */
     if (!blank_round())
     {
      /*
       * fiat lux
       */
      my_fade_in ();

      /*
       * OK, here we go, let's enter the main game loop
       */
      game ();
     }

     /*
      * let's be clean 8-)
      */
     free_game_memory();

     /*
      * we turn the volume down
      */
     WATER_VOLUME=CONFIG_WATER_VOLUME_MENU;

     /*
      * fade out before video mode switching
      */
     my_fade_out();
     /*
      * again, we change the video mode only if it is really required
      */
     if (need_to_change_mode(CONFIG_GFX_GAME,CONFIG_GFX_MENU,CONFIG_PAGE_FLIP))
		result=set_resolution (CONFIG_GFX_MENU,0);

     /*
      * displays the 3 tubes with the score
      */
     retour=display_scores ();
    }
  else
    {
     /*
      * the main reason why init_game should fail is a lack of big data
      * this can be cured by selecting a smaller level or increasing the
      * amount of data reserved at startup (command line parameter)
      */
     free_game_memory();
     error_not_enough_big_data ();
    }
  }

  return retour;
}

