/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : error.c                                          */
/* contenu       : messages d'erreur pendant le jeu                 */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "dialog.h"
#include "error.h"
#include "help.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int return_d_close(void)
{
 return (D_CLOSE);
}

/*------------------------------------------------------------------*/
static int standard_error (char *str)
{
   DIALOG d[3];

   color_one_dialog (d);
   d[0].proc=my_textbox_proc;
   d[0].d2=0;
   d[0].dp=str;
   d[0].key=0;
   d[0].flags=0;
   d[0].x=MENU_VIRTUAL_W/4;
   d[0].y=(3*MENU_VIRTUAL_H)/8;
   d[0].w=(MENU_VIRTUAL_W)/2;
   d[0].h=(MENU_VIRTUAL_H)/4;
   menu_real_coord (d);

   d[1].proc=d_keyboard_proc;
   d[1].dp=return_d_close;
   d[1].key=' ';
   d[1].d1=KEY_ENTER;
   d[1].d2=KEY_ESC;

   d[2].proc=NULL;

   my_do_dialog(d,0);
 
   return 0;
}

/*------------------------------------------------------------------*/
int error_not_enough_teams (void)
{
 return (standard_error("Not enough teams.\nYou must select at least 2 teams from the \"Teams\" menu."));
}

/*------------------------------------------------------------------*/
int error_not_enough_big_data (void)
{
 return (standard_error("Not enough memory to expand level.\nChoose a smaller level or see the \".htm\" doc and try command line options such as \"-mem n\"."));
}

/*------------------------------------------------------------------*/
int error_graphics_init_failed (void)
{
 return (standard_error("Unable to start graphic mode"));
}

/*------------------------------------------------------------------*/
int error_no_network_support (void)
{
 return (standard_error("No network support"));
}



