/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : keyexch.c                                        */
/* content       : code to exchange key presses with the server     */
/* last update   : June 24th  2001                                  */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "netkey.h"
#include "keyexch.h"

/*==================================================================*/
/* defines                                                          */
/*==================================================================*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

int LW_KEYEXCH_SOCK;

/*==================================================================*/
/* static functions                                                 */
/*==================================================================*/

static int send_keys(int sock, CURSOR *cursors);
static int recv_keys(int sock, CURSOR *cursors);

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int send_keys(int sock, CURSOR *cursors)
{
  int result=0;
  int i;
  LW_NETKEY netkey;

  lw_netkey_reset(&netkey);

  for (i=0;i<NB_TEAMS;++i)
    {
      /*
       * We send informations about cursors who are not network
       * controlled only.
       */
      if (!cursors[i].from_network)
	{
	  netkey.key_states[i]=cursors[i].key_state;
	}
    }

  result=lw_netkey_send(sock,&netkey);

  return result;
}

/*------------------------------------------------------------------*/
static int recv_keys(int sock, CURSOR *cursors)
{
  int result=0;
  int i;
  LW_NETKEY netkey;


  result=lw_netkey_recv(sock,&netkey);

  for (i=0;i<NB_TEAMS;++i)
    {
      /*
       * The informations is retrieved from the network for
       * _every_ cursor_ , including those who are not network
       * managed. In fact, we just wait for the server to send
       * back the information we have sent to him a few game
       * cycles before.
       */
      cursors[i].key_state=netkey.key_states[i];
    }

  return result;
}

/*------------------------------------------------------------------*/
int lw_keyexch_flush(CURSOR *cursors)
{
  int result=1;

  result=result && send_keys(LW_KEYEXCH_SOCK,cursors);
  result=result && recv_keys(LW_KEYEXCH_SOCK,cursors);

  return result;
}



