/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : srvchan.h                                        */
/* content       : handles a server network channel                 */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_SRVCHAN
#define LIQUID_WAR_INCLUDE_SRVCHAN

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "base.h"
#include "sockgen.h"
#include "srvteam.h"
#include "netkey.h"
#include "netconf.h"

/*==================================================================*/
/* structs                                                          */
/*==================================================================*/

typedef struct
{
  int sock;
  char ip[LW_SOCK_IP_SIZE];
  int port;
  int program_ok;
  int version_ok;
  int nickname_ok;
  int ready_ok;
  char nickname[NICKNAME_SIZE+1];
  int nb_local_teams;
  LW_SRVTEAM team[NB_TEAMS];
} LW_SRVCHAN;

/*==================================================================*/
/* fonctions globales                                               */
/*==================================================================*/

int lw_srvchan_wait_teams(LW_SRVCHAN *chan, int *free_teams,
			  int sock, void **map,LW_NETCONF *config);
int lw_srvchan_tell_who(LW_SRVCHAN *chan,void *map,LW_NETCONF *config);
int lw_srvchan_final_ok(LW_SRVCHAN *chan);
int lw_srvchan_find_team_by_server_id(LW_SRVCHAN *chan,int server_id);
int lw_srvchan_find_first_free_team(LW_SRVCHAN *chan);
void lw_srvchan_close(LW_SRVCHAN *chan);
int lw_srvchan_recv_keys(LW_SRVCHAN *chan, LW_NETKEY *netkey);
int lw_srvchan_send_keys(LW_SRVCHAN *chan, LW_NETKEY *netkey);

#endif




