/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : sock2cli.c                                       */
/* content       : wrapper functions used on the client             */
/* last update   : July  2md 2001                                   */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "sock2gen.h"
#include "ticker.h"

/*==================================================================*/
/* defines                                                          */
/*==================================================================*/

/*
 * there's a 12 sec timeout by default on the client
 */
#define LW_SOCK2CLI_TIMEOUT_MSEC        12000

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* static functions                                                 */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int lw_sock_peek(int sock, int len)
{
  int result=0;

  result=lw_sock_peek_ex(sock,len);

  return result;
}

/*------------------------------------------------------------------*/
int lw_sock_send_str(int sock, char *str)
{
  int result=0;
  int limit_ticker;

  /*
   * Now when allegro is running all standard sleep() or select()
   * UNIX functions do not work because allegro's timer messes
   * things up. Therefore we do our own dirty ugly select...
   */
  limit_ticker=get_ticker()+LW_SOCK2CLI_TIMEOUT_MSEC;
  while (limit_ticker>get_ticker() && !result)
    {
      if (lw_sock_send_str_ex(sock,str))
	{
	  result=1;
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
int lw_sock_recv_str(int sock, char *str)
{
  int result=0;
  int limit_ticker;

  /*
   * Now when allegro is running all standard sleep() or select()
   * UNIX functions do not work because allegro's timer messes
   * things up. Therefore we do our own dirty ugly select...
   */
  limit_ticker=get_ticker()+LW_SOCK2CLI_TIMEOUT_MSEC;
  while (limit_ticker>get_ticker() && !result)
    {
      if (lw_sock_recv_str_ex(sock,str))
	{
	  result=1;
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
int lw_sock_send_buffer(int sock, char *buffer,int len)
{
  int result=0;
  int limit_ticker;

  /*
   * Now when allegro is running all standard sleep() or select()
   * UNIX functions do not work because allegro's timer messes
   * things up. Therefore we do our own dirty ugly select...
   */
  limit_ticker=get_ticker()+LW_SOCK2CLI_TIMEOUT_MSEC;
  while (limit_ticker>get_ticker() && !result)
    {
      if (lw_sock_send_buffer_ex(sock,buffer,len))
	{
	  result=1;
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
int lw_sock_recv_buffer(int sock, char *buffer, int len)
{
  int result=0;
  int limit_ticker;

  /*
   * Now when allegro is running all standard sleep() or select()
   * UNIX functions do not work because allegro's timer messes
   * things up. Therefore we do our own dirty ugly select...
   */
  limit_ticker=get_ticker()+LW_SOCK2CLI_TIMEOUT_MSEC;
  while (limit_ticker>get_ticker() && !result)
    {
      if (lw_sock_recv_buffer_ex(sock,buffer,len))
	{
	  result=1;
	}
    }

  return result;
}





