/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : srvcont.h                                        */
/* content       : global controler of the network channels         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_SRVCONT
#define LIQUID_WAR_INCLUDE_SRVCONT

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "base.h"
#include "srvchan.h"
#include "netconf.h"

/*==================================================================*/
/* structs                                                          */
/*==================================================================*/

typedef struct
{
  int sock;
  int nb_teams;
  int nb_chans;
  LW_SRVCHAN chan[NB_TEAMS];
  void *map;
  LW_NETCONF config;
} LW_SRVCONT;

/*==================================================================*/
/* fonctions globales                                               */
/*==================================================================*/

int lw_srvcont_wait_teams(LW_SRVCONT *cont, int nb_teams,int port);
int lw_srvcont_tell_who(LW_SRVCONT *cont);
int lw_srvcont_final_ok(LW_SRVCONT *cont);
int lw_srvcont_replicate_keys(LW_SRVCONT *cont,int lag);
void lw_srvcont_close(LW_SRVCONT *cont);

#endif
