/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : options.c                                        */
/* contenu       : choix des options                                */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "base.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "disk.h"
#include "graphics.h"
#include "help.h"
#include "menu.h"
#include "options.h"
#include "sound.h"
#include "rules.h"
#include "volume.h"
#include "speeds.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int options (void)
{
 DIALOG d[10];
  int i,choix=4,retour=0;

  while (retour==0)
         {
          for (i=0; i<4; ++i)
              standard_button (d+i+4,0,i,1,6);
          standard_button (d+8,0,5,1,6);

          quick_buttons(d);
          d[4].dp="Graphics";
          d[5].dp="Sound";
          d[6].dp="Rules";
	  d[7].dp="Speeds";
          d[8].dp="Default";
          d[9].proc=0;

          choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_OPTIONS);
                  display_back_image ();
                  break;
             case 4:
                  retour=graphic_options ();
                  break;
             case 5:
                  retour=sound_options ();
                  break;
             case 6:
                  retour=rules_options ();
                  break;
             case 7:
                  retour=speeds_options ();
                  break;
             case 8:
		  load_default_options ();
                  retour=0;
                  break;
            }
        }

  if (retour>0)
    retour--;

  return retour;
 }


