/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : server.c                                         */
/* content       : main source for the liquidwar-server executable  */
/* last update   : April 14th 2001                                  */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "server.h"
#include "netmess.h"
#include "sockgen.h"
#include "parser.h"
#include "basicopt.h"
#include "srvcont.h"
#include "log.h"

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

#define LW_SERVER_IDENT_LAG "lag"
#define LW_SERVER_IDENT_PORT "port"

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

static int get_nb_teams();
static int get_lag();
static int get_port();

/*------------------------------------------------------------------*/
/*
 * This function returns how many teams there must be. Basically,
 * it checks the command line parameters, and if the number
 * of teams has not be told, then it prompts the user for it.
 */
static int get_nb_teams()
{
  int i;
  char str_i[33];
  int result=0;
  char c;

  for (i=1;i<NB_TEAMS;++i)
    {
      sprintf(str_i,"%d",i);
      if (exist_argument(str_i))
	{
	  result=i;
	}
    }

  if (result<2 || result>NB_TEAMS)
    {
      log_print_str("How many teams will connect to this server? ");

      c=getchar();
      if (c>='2' && c<='0'+NB_TEAMS)
	{
	  result=c-'0';
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
/*
 * This function returns the server lag.
 * This parameter is quite important, since it's the number of rounds
 * which will elapse between the moment when the client sends his
 * key strokes and the moment when he will receive them back from
 * the server, along with the information from other players.
 */
static int get_lag()
{
  int result=LW_SERVER_DEFAULT_LAG;

  if (exist_argument(LW_SERVER_IDENT_LAG))
    {
      result=get_argument_int(LW_SERVER_IDENT_LAG);
      if (result<0)
	{
	  result=0;
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
/*
 * Returns the port which should be used to communicate with clients
 */
static int get_port()
{
  int result=LW_SERVER_DEFAULT_PORT;

  if (exist_argument(LW_SERVER_IDENT_PORT))
    {
      result=get_argument_int(LW_SERVER_IDENT_PORT);
      if (result<=0)
	{
	  result=LW_SERVER_DEFAULT_PORT;
	}
    }

  return result;
}

/*------------------------------------------------------------------*/
/*
 * Main function, launches the server.
 * Here we don't need to use the END_OF_MAIN() hack of Allegro, since
 * under windows the game will be compiled as a console App
 * (no WinMain needed) and we don't use Allegro at all here anyway...
 */
int main(int argc, char **argv)
{
  int retcode=0;
  LW_SRVCONT cont;
  int nb_teams;
  int res=1;

  lw_sock_init();

  read_command_line (argc,argv);

  if (lw_basicopt_process("Liquid War Server"))
    {
      nb_teams=get_nb_teams();

      if (nb_teams>=2 && nb_teams<=NB_TEAMS)
	{
	  /*
	   * a good old infinite loop, the server has to be stopped
	   * with CTRL-C
	   */
	  while (1)
	    {
	      if (lw_srvcont_wait_teams(&cont, 
					nb_teams, 
					get_port()))
		{
		  if (lw_srvcont_tell_who(&cont))
		    {
		      if (lw_srvcont_final_ok(&cont))
			{
			  res=lw_srvcont_replicate_keys
			    (&cont, get_lag());
			}
		    }
		}
	      lw_srvcont_close(&cont);
	    }
	}
      else
	{
	  log_println_str("Not enough or too many teams!");
	}
    }

  lw_sock_exit();

  return retcode;
}













