/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : disk.c                                           */
/* contenu       : lecture des donnees du fichier .dat              */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>
#include <allegro.h>

#include "alleg2.h"
#include "init.h"
#include "disk.h"
#include "log.h"
#include "map.h"
#include "palette.h"
#include "startup.h"
#include "texture.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

int RAW_TEXTURE_NUMBER=0;
int RAW_MAP_NUMBER=0;

int LOADED_BACK=0;
int LOADED_TEXTURE=0;
int LOADED_SFX=0;
int LOADED_WATER=0;

SAMPLE *SAMPLE_SFX_TIME;
SAMPLE *SAMPLE_SFX_WIN;
SAMPLE *SAMPLE_SFX_GO;
SAMPLE *SAMPLE_SFX_CLICK;
SAMPLE *SAMPLE_SFX_LOOSE;

SAMPLE *SAMPLE_WATER[SAMPLE_WATER_NUMBER];
void   *RAW_MAP[RAW_MAP_MAX_NUMBER];
void   *RAW_MAP_ORDERED[RAW_MAP_MAX_NUMBER];
void   *RAW_TEXTURE[RAW_TEXTURE_MAX_NUMBER];

BITMAP *BACK_IMAGE;

FONT *BIG_FONT;
FONT *SMALL_FONT;
BITMAP *BIG_MOUSE_CURSOR;
BITMAP *SMALL_MOUSE_CURSOR;

char *HELP_TEXT[LANGAGE_NUMBER][HELP_TEXT_NUMBER];

static RGB *FONT_PALETTE;
static RGB *BACK_PALETTE;

/*------------------------------------------------------------------*/
/* chargement des effets sonores                                    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
static void lock_sound (SAMPLE *smp)
{
  LOCK_VARIABLE (*smp);
#ifdef ALLEGRO_DOS
  _go32_dpmi_lock_data (smp->data,(smp->bits/8)*smp->len);
#endif
}

/*------------------------------------------------------------------*/
static void read_sfx_dat (DATAFILE *df)
{
  SAMPLE_SFX_TIME=df[0].dat;
  SAMPLE_SFX_WIN=df[1].dat;
  SAMPLE_SFX_GO=df[2].dat;
  SAMPLE_SFX_CLICK=df[3].dat;
  SAMPLE_SFX_LOOSE=df[4].dat;

  lock_sound (SAMPLE_SFX_TIME);
  lock_sound (SAMPLE_SFX_WIN);
  lock_sound (SAMPLE_SFX_GO);
  lock_sound (SAMPLE_SFX_CLICK);
  lock_sound (SAMPLE_SFX_LOOSE);
}

/*------------------------------------------------------------------*/
static void read_water_dat (DATAFILE *df)
{
  int i;

  for (i=0; i<SAMPLE_WATER_NUMBER; ++i)
    {
      SAMPLE_WATER[i]=df[i].dat;
      lock_sound (SAMPLE_WATER[i]);
    }
}

/*------------------------------------------------------------------*/
/* chargement des autres donnees                                    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
static void read_texture_dat (DATAFILE *df)
{
  int i;

  RAW_TEXTURE_NUMBER=0;
  for (i=0; i<RAW_TEXTURE_DAT_NUMBER && df[i].type!=DAT_END; ++i)
    {
      RAW_TEXTURE[i]=df[i].dat;
      RAW_TEXTURE_NUMBER++;
    }
}

/*------------------------------------------------------------------*/
static void read_map_dat (DATAFILE *df)
{
  int i;

  RAW_MAP_NUMBER=0;
  for (i=0; i<RAW_MAP_DAT_NUMBER && df[i].type!=DAT_END; ++i)
    {
      RAW_MAP[i]=df[i].dat;
      RAW_MAP_NUMBER++;
    }
}

/*------------------------------------------------------------------*/
static void read_back_dat (DATAFILE *df)
{
  int i,x,y;

  BACK_PALETTE=df[1].dat;
  BACK_IMAGE=df[0].dat;

  /*
   * strange, with Allegro 4.0, the liquidwarcol utility
   * and the datafile compiler do not work so well together,
   * and so the palette stored in the datafile always
   * start at color 0, which explains the "18 shift"
   */

  for (i=0; i<=45; ++i)
    GLOBAL_PALETTE[i+18]=BACK_PALETTE[i];

  for (x=0;x<BACK_IMAGE->w;++x)
    for (y=0;y<BACK_IMAGE->w;++y)
      {
	putpixel(BACK_IMAGE,x,y,getpixel(BACK_IMAGE,x,y)+18);
      }
}

/*------------------------------------------------------------------*/
static void create_default_back(void)
{
  static RGB back_coul={1,1,8};

  BACK_IMAGE=my_create_bitmap (1,1);
  putpixel (BACK_IMAGE,0,0,18);
  GLOBAL_PALETTE[18]=back_coul;
}

/*------------------------------------------------------------------*/
static void read_font_dat (DATAFILE *df)
{
  int i;

  FONT_PALETTE=df[4].dat;
  SMALL_FONT=df[0].dat;
  BIG_FONT=df[1].dat;
  SMALL_MOUSE_CURSOR=df[2].dat;
  BIG_MOUSE_CURSOR=df[3].dat;

  for (i=1; i<=17; ++i)
    GLOBAL_PALETTE[i]=FONT_PALETTE[i];
}

/*------------------------------------------------------------------*/
static void read_help_dat (DATAFILE *df)
{
  int i,j,l;
  DATAFILE *temp;

  for (i=0;i<LANGAGE_NUMBER;++i)
    {
      temp=df[i].dat;
      for (j=0;j<HELP_TEXT_NUMBER;++j)
        {
	  HELP_TEXT[i][j]=temp[j].dat;
	  l=temp[j].size;
	  HELP_TEXT[i][j][l-1]=0;
        }
    }
}

/*------------------------------------------------------------------*/
int load_dat (void)
{
  int result=1;
  int loadable;
  DATAFILE *df;

  log_print_str("Loading data from \"");
  log_print_str(STARTUP_DAT_PATH);
  log_print_str("\"");

#ifdef ALLEGRO_DOS
  loadable=1;  
#else
  loadable=exists(STARTUP_DAT_PATH);
#endif

  display_success(loadable);

  if (loadable)
    {
      log_print_str( "Loading help messages");
      log_flush();
      df=load_datafile_object (STARTUP_DAT_PATH,"help_dat");
      if (result&=(df!=NULL))
        read_help_dat (df[0].dat);
      display_success (df!=NULL);
    }
  if (loadable)
    {
      log_print_str( "Loading fonts");
      log_flush();
      df=load_datafile_object (STARTUP_DAT_PATH,"font_dat");
      if (result&=(df!=NULL))
        read_font_dat (df[0].dat);
      display_success (df!=NULL);
    }
  if (loadable)
    {
      log_print_str( "Loading maps");
      log_flush();
      df=load_datafile_object (STARTUP_DAT_PATH,"map_dat");
      if (result&=(df!=NULL))
        read_map_dat (df[0].dat);
      display_success (df!=NULL);
    }

  if (loadable && STARTUP_BACK_STATE)
    {
      log_print_str( "Loading background bitmap");
      log_flush ();
      df=load_datafile_object (STARTUP_DAT_PATH,"back_dat");
      if (df!=NULL)
	{
	  read_back_dat (df[0].dat);
	  LOADED_BACK=1;
	}
      else
        {
	  create_default_back ();
	  result&=!STARTUP_CHECK;
        }
      display_success (df!=NULL);
    }
  else
    create_default_back ();
  if (loadable && STARTUP_SFX_STATE)
    {
      log_print_str( "Loading sound fx");
      log_flush();
      df=load_datafile_object (STARTUP_DAT_PATH,"sfx_dat");
      if (df!=NULL)
	{
	  read_sfx_dat (df[0].dat);
	  LOADED_SFX=1;
	}
      else
	result&=!STARTUP_CHECK;
      display_success (df!=NULL);
    }
  if (loadable && STARTUP_TEXTURE_STATE)
    {
      log_print_str( "Loading textures");
      log_flush();
      df=load_datafile_object (STARTUP_DAT_PATH,"texture_dat");
      if (df!=NULL)
	{
	  read_texture_dat (df[0].dat);
	  LOADED_TEXTURE=1;
	}
      else
	result&=!STARTUP_CHECK;
      display_success (df!=NULL);
    }

  if (loadable && STARTUP_WATER_STATE)
    {
      log_print_str( "Loading water sounds");
      log_flush ();
      df=load_datafile_object (STARTUP_DAT_PATH,"water_dat");
      if (df!=NULL)
	{
	  read_water_dat (df[0].dat);
	  LOADED_WATER=1;
	}
      else
	result&=!STARTUP_CHECK;
      display_success (df!=NULL);
    }

  return loadable && result;
}

/*------------------------------------------------------------------*/
static void load_custom_texture_callback(const char *file, int mode, int unused)
{
  void *pointeur;

  if ((pointeur=archive_raw_texture(file)) !=NULL)
    {
      RAW_TEXTURE[RAW_TEXTURE_NUMBER++]=pointeur;
      log_print_str(".");
      log_flush();
    }
}

/*------------------------------------------------------------------*/
static int load_custom_texture (void)
{
  int result=1;
  char buf[512];
  int l;

  strcpy(buf,STARTUP_TEX_PATH);
  l=strlen(buf);

#ifdef ALLEGRO_UNIX
  strcpy(buf+l,"/*");
#else
  strcpy(buf+l,"\\*.*");
#endif
  for_each_file(buf,FA_RDONLY,load_custom_texture_callback,0);

  return result;
}

/*------------------------------------------------------------------*/
static void load_custom_map_callback(const char *file, int mode, int unused)
{
  void *pointeur;

  if ((pointeur=archive_raw_map(file)) !=NULL)
    {
      RAW_MAP[RAW_MAP_NUMBER++]=pointeur;
      log_print_str(".");
      log_flush();
    }
}

/*------------------------------------------------------------------*/
static int load_custom_map (void)
{
  int result=1;
  char buf[512];
  int l;

  strcpy(buf,STARTUP_MAP_PATH);
  l=strlen(buf);

#ifdef ALLEGRO_UNIX
  strcpy(buf+l,"/*");
#else
  strcpy(buf+l,"\\*.*");
#endif
  for_each_file(buf,FA_RDONLY,load_custom_map_callback,0);

  return result;
}

/*------------------------------------------------------------------*/
int load_custom (void)
{
  int success,result=1;

  if (STARTUP_TEXTURE_STATE && STARTUP_CUSTOM_STATE)
    {
      log_print_str( "Loading custom textures from \"");
      log_print_str(STARTUP_TEX_PATH);
      log_print_str("\"");
      log_flush();
      success=load_custom_texture ();
      if (!success)
	result&=!STARTUP_CHECK;
      display_success (success);
    }

  if (STARTUP_CUSTOM_STATE)
    {
      log_print_str( "Loading custom maps from \"");
      log_print_str(STARTUP_MAP_PATH);
      log_print_str("\"");
      log_flush();
      success=load_custom_map();
      if (!success)
	result&=!STARTUP_CHECK;
      display_success (success);
    }

  return result;
}

/*------------------------------------------------------------------*/
void order_map (void)
{
  /* char placed[RAW_MAP_MAX_NUMBER];
     int i,j,n=0,size,low_limit;
     int *data;

     for (i=0; i<RAW_MAP_NUMBER; ++i)
     placed[i]=0;

     for (i=0; i<RAW_MAP_NUMBER; ++i)
     {
     low_limit=1000000000;
     for (j=0; j<RAW_MAP_NUMBER ; ++j)
     {
     if (!placed[j])
     {
     data=RAW_MAP[j];
     size=data[0];
     if (size<=low_limit)
     {
     n=j;
     low_limit=size;
     }
     }
     }
     placed[n]=1;
     RAW_MAP_ORDERED[i]=RAW_MAP[n];
     }*/

  int incorrect_order=1;
  int i;


  char name1[LW_MAP_READABLE_NAME_SIZE+1];
  char name2[LW_MAP_READABLE_NAME_SIZE+1];
  void *temp;

  for (i=0;i<RAW_MAP_NUMBER;++i)
    {
      RAW_MAP_ORDERED[i]=RAW_MAP[i];
    }

  while (incorrect_order)
    {
      incorrect_order=0;

      for (i=0;i<RAW_MAP_NUMBER-1;++i)
	{
	  strcpy(name1,get_map_readable_name(i));
	  strcpy(name2,get_map_readable_name(i+1));
	  if (strcmp(name1,name2)>0)
	    {
	      incorrect_order=1;

	      temp=RAW_MAP_ORDERED[i];
	      RAW_MAP_ORDERED[i]=RAW_MAP_ORDERED[i+1];
	      RAW_MAP_ORDERED[i+1]=temp;
	    }
	}
    }
}

