/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : exit.c                                           */
/* contenu       : fin d'allero et messages d'adieu                 */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "exit.h"
#include "log.h"
#include "sound.h"
#include "startup.h"
#include "ticker.h"
#include "sockgen.h"

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/* fonction de desinstallation d'allegro                            */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
static void exit_all (void)
{
 #ifdef ALLEGRO_DOS
 set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
 #endif
 log_println();
 log_println_str ("Leaving Allegro (http://www.talula.demon.co.uk/allegro)");
 save_config_options ();
 stop_water();
 stop_ticker();
 remove_sound ();
 remove_mouse ();
 clear_keybuf ();
 remove_keyboard ();
 remove_timer ();
 allegro_exit ();
 lw_sock_exit ();
}

/*------------------------------------------------------------------*/
static void disp_base_message (void)
{
 log_println_str("Liquid War " LW_VERSION " by U-Foot.");
 log_println_str("This release compiled on " __DATE__ ".");
 log_println();
 log_println_str("E-mail    : ufoot@ufoot.org");
 log_println_str("Web       : http://www.ufoot.org");
 log_println_str("Address   : Christian Mauduit");
 log_println_str("            8 Allee de la Fresnaie");
 log_println_str("            95120 Ermont FRANCE");
 log_println();
 log_println_str("This game is FREE SOFTWARE, protected by the GPL (www.fsf.org).");
 log_println_str("You can use it, copy it, distribute it and modify it.");
 log_println_str("The source code is available on my web site.");
 log_println_str("Liquid War should stay free software for ever.");
 log_println_str("I am NOT responsible for any damage caused by this software.");
 log_println();
 log_println_str("Check out http://www.ufoot.org/liquidwar for complete information.");
}

/*------------------------------------------------------------------*/
static void disp_ok_message (void)
{
 log_println_str("Thanks for playing Liquid War!");
 log_println_str("I hope you enjoyed it.");
}

/*------------------------------------------------------------------*/
static void disp_error_message (void)
{
 log_println_str("Thanks for trying to play Liquid War...");
 log_println_str("I'm sorry about the trouble it's causing you.");
}

/*------------------------------------------------------------------*/
static void disp_init_fail_message (void)
{
 log_println_str("An error occured during the init process.");
 log_println();
 log_println_str("Try \"lw -silent\" to disable sound management.");
 log_println_str("Try \"lw -nojoy\" to disable joystick control.");
 log_println();
 log_println_str("Try to delete your \"lw.cfg\" file and restart Liquid War.");
}

/*------------------------------------------------------------------*/
static void disp_common_memory_message (void)
{
 log_println_str("Try \"lw -auto\" if you don't want to waste your time.");
 log_println();
 log_println_str("Try \"lw -mem n\" where 'n' is the number of Mb to be allocated by Liquid War");
 log_println_str("to do all his calculus. The lower it is, the safer it is in general, but you");
 log_println_str("won't be able to play with all the levels if 'n' is too small.");
 log_println_str("'n' can range from 1 to 32, default is 8.");
 log_println();
 log_println_str("If you run Liquid War from Windows, try and give it more DPMI memory.");
 log_println();
 log_println_str("Try \"lw -noback\" to skip background image loading.");
 log_println_str("Try \"lw -notex\" to skip texture loading.");
 log_println_str("Try \"lw -nowater\" to skip water sounds loading.");
 log_println_str("Try \"lw -nosfx\" to skip sound fx loading.");
 log_println();
 log_println_str("Try \"lw -nice\" if \"lw -auto\" doesn't work correctly.");
 log_println_str("Try \"lw -safe\" if nothing else works.");
}

/*------------------------------------------------------------------*/
static void disp_big_data_message (void)
{
 log_println_str("Liquid War was unable to allocate memory for its calculus.");
 log_println();
 disp_common_memory_message ();
}

/*------------------------------------------------------------------*/
static void disp_mem_trouble_message (void)
{
 log_println_str("Liquid War is running short of memory for its bitmaps.");
 log_println();
 disp_common_memory_message ();
}

/*------------------------------------------------------------------*/
static void disp_load_fail_message (void)
{
 log_println_str("Liquid War was unable to load your datafile components.");
 log_println();
 log_print_str("Please first check that \"");
 log_print_str(STARTUP_DAT_PATH);
 log_print_str("\" exists.");
 log_println();
 log_println();
 disp_common_memory_message ();
}

/*------------------------------------------------------------------*/
static void disp_custom_fail_message (void)
{
 log_println_str("Liquid War was unable to load your custom maps.");
 log_println();
 log_println_str("This can happen when:");
 log_println();
 log_println_str("The path is wrong, use \"lw -tex path\" or \"lw -map path\".");
 log_println_str("Your bitmaps are not correct, just change them.");
 log_println_str("You don't have enough memory.");
}

/*------------------------------------------------------------------*/
static void disp_integrity_message (void)
{
 log_println_str("Your \".exe\" or \".dat\" file has been modified");
 log_println();
 log_println_str("First check that \"lw.dat\" is in the \".\\data\\\" directory.");
 log_println_str("If you used the \"lw -dat\" switch, check that the path is correct.");
 log_println();
 log_println_str("If this doesn't work, try and reload the original files from my web site.");
}

/*------------------------------------------------------------------*/
void my_exit (int code)
{
 exit_all();
 log_println();
 if (code==EXIT_CODE_OK)
    {
     disp_base_message ();
     log_println();
     disp_ok_message ();
    }
 else
     {
      log_flush();
      switch (code)
        {
         case EXIT_CODE_INIT_FAIL:
              disp_init_fail_message();
              break;
         case EXIT_CODE_MEM_TROUBLE:
              disp_mem_trouble_message();
              break;
         case EXIT_CODE_INTEGRITY:
              disp_integrity_message();
              break;
         case EXIT_CODE_BIG_DATA:
              disp_big_data_message();
              break;
         case EXIT_CODE_LOAD_FAIL:
              disp_load_fail_message();
              break;
         case EXIT_CODE_CUSTOM_FAIL:
              disp_custom_fail_message();
              break;
        }
     #ifndef ALLEGRO_UNIX
     getch ();
     #endif
	  log_println();
	  log_println();
	  log_println();
      disp_base_message ();
      log_println();
      disp_error_message ();
     }

 log_println();
 exit (code);
}



