/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : joystick.c                                       */
/* contenu       : gestion du joystick                              */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "joystick.h"
#include "startup.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int my_initialise_joystick (void)
{
 #ifdef ALLEGRO_DOS
	#define JOY_TYPE0 JOY_TYPE_2PADS
	#define JOY_TYPE1 JOY_TYPE_4BUTTON
	#define JOY_TYPE2 JOY_TYPE_STANDARD
 #endif

 #ifdef ALLEGRO_WINDOWS
	#define JOY_TYPE0 JOY_TYPE_AUTODETECT
	#define JOY_TYPE1 JOY_TYPE_AUTODETECT
	#define JOY_TYPE2 JOY_TYPE_AUTODETECT
 #endif

 #ifdef ALLEGRO_UNIX
	#define JOY_TYPE0 JOY_TYPE_AUTODETECT
	#define JOY_TYPE1 JOY_TYPE_AUTODETECT
	#define JOY_TYPE2 JOY_TYPE_AUTODETECT
 #endif

	if (STARTUP_JOYSTICK_ON)
    {
#ifdef joy_type
     switch (CONFIG_JOYSTICK_ON)
        {
         case 1: joy_type=JOY_TYPE0;
                 break;
         case 2: joy_type=JOY_TYPE1;
                 break;
         case 3: joy_type=JOY_TYPE2;
                 break;
        }
#endif
     return initialise_joystick ();
    }
 else
     return -1;
}

/*------------------------------------------------------------------*/
void my_poll_joystick (void)
{
 if (CONFIG_JOYSTICK_ON && STARTUP_JOYSTICK_ON)
    poll_joystick();
}

