/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : menu.c                                           */
/* contenu       : aaffichages des menus principaux                 */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "level.h"
#include "menu.h"
#include "options.h"
#include "play.h"
#include "team.h"
#include "netgame.h"
#include "network.h"
#include "error.h"

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int confirm_quit (void)
{
  DIALOG d[3];

  d[2].proc=NULL;
  standard_button (d,0,0,2,1);
  standard_button (d+1,1,0,2,1);
  d[0].dp="Exit";
#ifdef ALLEGRO_DOS
  d[0].dp="Exit to DOS";
#endif
#ifdef ALLEGRO_WINDOWS
  d[0].dp="Exit to Windows";
#endif
#ifdef ALLEGRO_UNIX
  d[0].dp="Exit to Unix";
#endif
#ifdef ALLEGRO_LINUX
  d[0].dp="Exit to Linux";
#endif
  d[1].dp="Back to LW";
  d[0].key='d';
  d[1].key='w';

  return (my_do_dialog (d,0)==0);
}

/*------------------------------------------------------------------*/
/* lancement du menu principal                                      */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
void main_menu (void)
{
  DIALOG d[11];
  int i,choix=4,retour=0;

  display_back_image ();
  /*
    dp=init_dialog (d,4);
    update_dialog (dp);
    shutdown_dialog (dp);
  */
  my_fade_in ();

  while (retour!=MENU_EXIT)
    {
      for (i=0; i<6; ++i)
	standard_button (d+i+4,0,i,1,6);

      quick_buttons(d);
      d[MENU_QUICK_BACK].flags=D_HIDDEN;
      d[MENU_QUICK_MAIN].flags=D_HIDDEN;
      d[4].dp="Play";
      d[5].dp="Net game";
      d[6].dp="Map";
      d[7].dp="Teams";
      d[8].dp="Options";
      d[9].dp="About";
      d[10].proc=0;

      choix=my_do_dialog (d,choix);
      switch (choix)
	{
	case -1:
	case MENU_QUICK_QUIT:
	  if (confirm_quit())
	    retour=MENU_EXIT;
	  break;
	case MENU_QUICK_HELP:
	  retour=display_help (HELP_TEXT_MAIN);
	  break;
	case 4:
	  LW_NETWORK_ON=0;
	  retour=play_sequence ();
	  break;
	case 5:
#ifndef ALLEGRO_DOS
	  retour=network_game ();
#else
	  retour=error_no_network_support ();
#endif
	  break;
	case 6:
	  retour=choose_map ();
	  break;
	case 7:
	  retour=choose_teams ();
	  break;
	case 8:
	  retour=options ();
	  break;
	case 9:
	  retour=display_help (HELP_TEXT_ABOUT);
	  break;
	}
    }
}

