/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : netkey.h                                         */
/* content       : functions to manipulate network key messages     */
/* last update   : June 20th 2001                                   */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_NETKEY
#define LIQUID_WAR_INCLUDE_NETKEY

#include "base.h"

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

#define LW_NETKEY_CMD_NONE          'n'
#define LW_NETKEY_CMD_QUIT          'q'     
#define LW_NETKEY_CMD_INCREASE_LAG  '+'
#define LW_NETKEY_CMD_DECREASE_LAG  '-'

/*==================================================================*/
/* structs                                                          */
/*==================================================================*/

/*
 * This structure is used to store the information about keys strokes
 * sent over the network. The structure contains the keys plus
 * 2 special fields: a command and a parameter.
 */
typedef struct
{
  int key_states[NB_TEAMS];     /* the keys states as in the cursor */
  int cmd;                      /* a special command                */
  int arg;                      /* an argument for the command      */
} LW_NETKEY;

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

void lw_netkey_reset(LW_NETKEY *netkey);
int lw_netkey_send(int sock,LW_NETKEY *netkey);
int lw_netkey_recv(int sock,LW_NETKEY *netkey);
int lw_netkey_peek(int sock,int num);

#endif
