/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* name          : protocol.h                                       */
/* content       : messages sent by the client when connecting      */
/* last update   : April 16th 2001                                  */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_PROTOCOL
#define LIQUID_WAR_INCLUDE_PROTOCOL

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "network.h"

/*==================================================================*/
/* fonctions globales                                               */
/*==================================================================*/

int lw_protocol_do_ping (int sock);
int lw_protocol_tell_version (int sock, char *version);
int lw_protocol_tell_program (int sock, char *program);
int lw_protocol_tell_nickname (int sock, char *nickname);
int lw_protocol_ask_free_teams (int sock, int *nb);
int lw_protocol_reserve_team (int sock, int num);
int lw_protocol_ask_who (int sock, 
			 int num,
			 LW_WHO *who);
int lw_protocol_send_map (int sock, void *map);
int lw_protocol_recv_map (int sock, void **map);
int lw_protocol_send_config (int sock);
int lw_protocol_recv_config (int sock);
int lw_protocol_i_am_ready (int sock); 

#endif
