/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : startup.c                                        */
/* contenu       : parametres de demarrage                          */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>
#include <stdlib.h>
#include <string.h>

#include "parser.h"
#include "startup.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

#define IDENT_MEM                 "mem"
#define IDENT_NOBACK              "noback"
#define IDENT_NOTEXTURE           "notex"
#define IDENT_NOWATER             "nowater"
#define IDENT_NOSFX               "nosfx"
#define IDENT_NOCUSTOM            "nocustom"
#define IDENT_NOSOUND             "silent"
#define IDENT_NOSVGA              "vga"
#define IDENT_NOASM               "c"
#define IDENT_NOJOY               "nojoy"
#define IDENT_STOP                "stop"
#define IDENT_SAFE                "safe"
#define IDENT_NICE                "nice"
#define IDENT_AUTO                "auto"
#define IDENT_CHECK               "check"
#define IDENT_CFG                 "cfg"
#define IDENT_DAT                 "dat"
#define IDENT_MAP                 "map"
#define IDENT_TEX                 "tex"

#define STARTUP_MAX_PATH_LENGTH           1000

#ifdef ALLEGRO_DOS
int STARTUP_BIG_DATA=8192;
#else
int STARTUP_BIG_DATA=16384;
#endif
int STARTUP_DIGI_CARD=DIGI_AUTODETECT;
int STARTUP_JOYSTICK_ON=1;
int STARTUP_BACK_STATE=1;
int STARTUP_TEXTURE_STATE=1;
int STARTUP_WATER_STATE=1;
int STARTUP_SFX_STATE=1;
int STARTUP_CUSTOM_STATE=1;
int STARTUP_ASM=1;
int STARTUP_SVGA=1;
int STARTUP_STOP=0;
int STARTUP_AUTO=0;
int STARTUP_CHECK=0;

#ifdef ALLEGRO_UNIX
  static char *DEFAULT_CFG_PATH=CONFIG_UNIX_CFG;
  static char *DEFAULT_DAT_PATH=CONFIG_UNIX_DAT;
  static char *DEFAULT_MAP_PATH=CONFIG_UNIX_MAP;
  static char *DEFAULT_TEX_PATH=CONFIG_UNIX_TEX;
#else
  static char *DEFAULT_CFG_PATH="data/lw.cfg";
  static char *DEFAULT_DAT_PATH="data/lw.dat";
  static char *DEFAULT_MAP_PATH="custom/map/";
  static char *DEFAULT_TEX_PATH="custom/texture/";
#endif

char STARTUP_CFG_PATH[STARTUP_MAX_PATH_LENGTH];
char STARTUP_DAT_PATH[STARTUP_MAX_PATH_LENGTH];
char STARTUP_MAP_PATH[STARTUP_MAX_PATH_LENGTH];
char STARTUP_TEX_PATH[STARTUP_MAX_PATH_LENGTH];

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void set_bigdata_size (void)
{
 int bigd;

 if (exist_argument_value(IDENT_MEM))
    {
     bigd=get_argument_int(IDENT_MEM);
     if (bigd<1)
        bigd=1;
     if (bigd>32)
        bigd=32;
     STARTUP_BIG_DATA=bigd*1024;
    }
}

/*------------------------------------------------------------------*/
static void set_joystick (void)
{
 if (exist_argument (IDENT_NOJOY))
    STARTUP_JOYSTICK_ON=0;
}

/*------------------------------------------------------------------*/
static void set_load_states (void)
{
 if (exist_argument (IDENT_NOBACK))
    STARTUP_BACK_STATE=0;
 if (exist_argument (IDENT_NOTEXTURE))
    STARTUP_TEXTURE_STATE=0;

 if (exist_argument (IDENT_NOWATER)
    || exist_argument (IDENT_NOSOUND))
    STARTUP_WATER_STATE=0;
 if (exist_argument (IDENT_NOSFX)
    || exist_argument (IDENT_NOSOUND))
    STARTUP_SFX_STATE=0;

 if (exist_argument (IDENT_NOSOUND)
    || ( exist_argument (IDENT_NOSFX)
    && exist_argument (IDENT_NOWATER)))
    STARTUP_DIGI_CARD=DIGI_NONE;

 if (exist_argument (IDENT_NOCUSTOM))
    STARTUP_CUSTOM_STATE=0;
}

/*------------------------------------------------------------------*/
static void set_graphic_possibilities (void)
{
 if (exist_argument (IDENT_NOSVGA))
    STARTUP_SVGA=0;
}

/*------------------------------------------------------------------*/
static void set_c_or_asm (void)
{
 if (exist_argument (IDENT_NOASM))
    STARTUP_ASM=0;
}

/*------------------------------------------------------------------*/
static void set_stop (void)
{
 if (exist_argument (IDENT_STOP))
    STARTUP_STOP=1;
}

/*------------------------------------------------------------------*/
static void set_auto_check (void)
{
 if (exist_argument (IDENT_AUTO))
    {
     STARTUP_AUTO=1;
     STARTUP_CHECK=0;
    }
 if (exist_argument (IDENT_CHECK))
    {
     STARTUP_AUTO=0;
     STARTUP_CHECK=1;
     STARTUP_STOP=1;
    }
}

/*------------------------------------------------------------------*/
static void set_safe (void)
{
 if (exist_argument (IDENT_NICE))
    {
     STARTUP_BIG_DATA=4096;
     STARTUP_SVGA=0;
    }

 if (exist_argument (IDENT_SAFE))
    {
     STARTUP_JOYSTICK_ON=0;
     STARTUP_BIG_DATA=1024;
     STARTUP_DIGI_CARD=DIGI_NONE;
     STARTUP_BACK_STATE=0;
     STARTUP_TEXTURE_STATE=0;
     STARTUP_WATER_STATE=0;
     STARTUP_SFX_STATE=0;
     STARTUP_CUSTOM_STATE=0;
     STARTUP_SVGA=0;
    }
}

/*------------------------------------------------------------------*/
static void correct_path (char *path)
{
 int l;
 char c;

 l=strlen (path);
 if (l>0)
    {
     c=path[l-1];
     if (c=='/' || c=='\\')
      {
        path[--l]=0;
      }
    }
}

/*------------------------------------------------------------------*/
static void set_path (void)
{
 char home_path[512];
 char *home_env;

 if (exist_argument_value (IDENT_CFG))
     strcpy(STARTUP_CFG_PATH,get_argument_str (IDENT_CFG));
 else
    {
    #ifdef ALLEGRO_UNIX
         home_env=getenv("HOME"); 
         strcpy(home_path,home_env);
         strcat(home_path,"/");
    #else
         home_env="";
         strcpy(home_path,home_env);
    #endif
     strcpy(STARTUP_CFG_PATH,home_path);
     strcat(STARTUP_CFG_PATH,DEFAULT_CFG_PATH);
    }

 if (exist_argument_value (IDENT_DAT))
     strcpy(STARTUP_DAT_PATH,get_argument_str (IDENT_DAT));
 else
     strcpy(STARTUP_DAT_PATH,DEFAULT_DAT_PATH);

 if (exist_argument_value (IDENT_TEX))
     strcpy(STARTUP_TEX_PATH,get_argument_str (IDENT_TEX));
 else
     strcpy(STARTUP_TEX_PATH,DEFAULT_TEX_PATH);

 if (exist_argument_value (IDENT_MAP))
     strcpy(STARTUP_MAP_PATH,get_argument_str (IDENT_MAP));
 else
     strcpy(STARTUP_MAP_PATH,DEFAULT_MAP_PATH);


 correct_path (STARTUP_TEX_PATH);
 correct_path (STARTUP_MAP_PATH);
}

/*------------------------------------------------------------------*/
static void set_platform_specific (void)
{
	#ifdef ALLEGRO_WINDOWS
		STARTUP_ASM=0;	
	#endif
}

/*------------------------------------------------------------------*/
void set_startup (void)
{
 set_joystick();
 set_load_states();
 set_graphic_possibilities();
 set_c_or_asm();
 set_path();
 set_stop();
 set_safe();
 set_auto_check();
 set_bigdata_size();
 set_platform_specific();
}


