/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : level.c                                          */
/* contenu       : choix du niveau a jouer                          */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdio.h>
#include <string.h>

#include "back.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "level.h"
#include "map.h"
#include "menu.h"
#include "palette.h"
#include "sound.h"
#include "texture.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void palette_128 (DIALOG *d,int x, int y, int w, int h)
{
  int w1,h1,w2,h2,i,j,k;

  w+=2;
  h+=2;
  w1=w/10;
  h1=h/13;
  w2=w1-2;
  h2=h1-2;

  for (k=0; k<128; ++k)
    {
      d[k].proc=d_button_proc;
      d[k].key=0;
      d[k].dp="";
      d[k].w=w2;
      d[k].h=h2;
      d[k].fg=MENU_FG;
      d[k].flags=D_EXIT;
      d[k].bg=k+128;
    }
  k=0;
  for (i=0;i<12;++i)
    for (j=0;j<10;++j)
      {
        d[k].x=x+j*w1;
        d[k].y=y+i*h1;
        ++k;
      }

  d[k].x=x;
  d[k].y=y+12*h1;
  d[k].w=2*w2+2;
  k++;
  for (j=0;j<6;++j)
    {
      d[k].x=x+(j+2)*w1;
      d[k].y=y+12*h1;
      ++k;
    }
  d[k].x=x+8*w1;
  d[k].y=y+12*h1;
  d[k].w=2*w2+2;
}

/*------------------------------------------------------------------*/
static void retrieve_choose_level_xy (int *x1,
                                      int *x2,
                                      int *x3,
                                      int *x4,
                                      int *x5,
                                      int *x6,
                                      int *y1,
                                      int *y2,
                                      int *y3,
                                      int *y4,
                                      int *y5,
				      int *y6)
{
  (*x1)= (MENU_VIRTUAL_W -MENU_W_LEVEL*2
	  -MENU_H_LEVEL*2
	  -MENU_W_SPACE*2
	  -MENU_H_SPACE*2
	  -MENU_W_SAMPLE)/2;
  (*x2)=(*x1)+MENU_H_SPACE+MENU_H_LEVEL;
  (*x3)=(*x1)+MENU_W_SPACE+MENU_W_LEVEL;
  (*x4)=(*x3)+MENU_H_LEVEL+MENU_H_SPACE;
  (*x5)=(*x4)+MENU_W_SAMPLE+MENU_W_SPACE;
  (*x6)=(*x5)+MENU_H_LEVEL+MENU_H_SPACE;

  (*y1)= (MENU_VIRTUAL_H -MENU_H_LEVEL*2
	  -MENU_H_SPACE*2
	  -MENU_H_SAMPLE)/2;
  (*y2)=(*y1)+MENU_H_LEVEL+MENU_H_SPACE;
  (*y3)=(*y1)+MENU_W_LEVEL+MENU_H_SPACE;
  (*y4)=(*y1)+MENU_H_SAMPLE-MENU_H_LEVEL;
  (*y5)=(*y4)+MENU_H_LEVEL+MENU_H_SPACE;
  (*y6)=(*y5)+MENU_H_LEVEL+MENU_H_SPACE;
}

/*------------------------------------------------------------------*/
static void display_chosen_level (void)
{
  int  x1,x2,x3,x4,x5,x6,y1,y2,y3,y4,y5,y6;
  int  sample_x,sample_y,sample_w,sample_h;
  int  max_w,max_h,bmp_w,bmp_h;
  BITMAP *pour_voir;

  retrieve_choose_level_xy (&x1,&x2,&x3,&x4,&x5,&x6,
			    &y1,&y2,&y3,&y4,&y5,&y6);

  rectfill (screen, menu_real_x(x4),
	    menu_real_y(y1),
	    menu_real_x(x4+MENU_W_SAMPLE)-1,
	    menu_real_y(y1+MENU_H_SAMPLE)-1,MENU_BG);
  rectfill (screen, menu_real_x(x1),
	    menu_real_y(y1),
	    menu_real_x(x1+MENU_W_LEVEL)-1,
	    menu_real_y(y1+MENU_W_LEVEL)-1,MENU_BG);
  rectfill (screen, menu_real_x(x6),
	    menu_real_y(y1),
	    menu_real_x(x6+MENU_W_LEVEL)-1,
	    menu_real_y(y1+MENU_W_LEVEL)-1,MENU_BG);

  set_bg_texture_palette (CONFIG_LEVEL_BG);
  set_fg_texture_palette (CONFIG_LEVEL_FG);
  my_set_palette ();

  pour_voir=create_textured_map (CONFIG_LEVEL_MAP,
				 CONFIG_LEVEL_FG,
				 CONFIG_LEVEL_BG,
				 0);
  if (pour_voir)
    {
      max_w=menu_real_x(MENU_W_SAMPLE);
      max_h=menu_real_y(MENU_H_SAMPLE);
      bmp_w=pour_voir->w;
      bmp_h=pour_voir->h;
      if (max_w*bmp_h<max_h*bmp_w)
	{
	  sample_w=max_w;
	  sample_h=(max_w*bmp_h)/bmp_w;
	}
      else
	{
	  sample_w=(max_h*bmp_w)/bmp_h;
	  sample_h=max_h;
	}
      sample_x=menu_real_x(x4)+(max_w-sample_w)/2;
      sample_y=menu_real_y(y1)+(max_h-sample_h)/2;
      stretch_blit (pour_voir,
		    screen, 0, 0, bmp_w, bmp_h,
		    sample_x,sample_y,sample_w,sample_h);
      destroy_bitmap (pour_voir);
    }

  pour_voir=create_fg_texture (CONFIG_LEVEL_FG);
  if (pour_voir)
    {
      stretch_blit (pour_voir, screen, 0, 0,
		    pour_voir->w, pour_voir->h,
		    menu_real_x(x1),
		    menu_real_x(y1),
		    menu_real_x(MENU_W_LEVEL),
		    menu_real_x(MENU_W_LEVEL));
      destroy_bitmap (pour_voir);
    }

  pour_voir=create_bg_texture (CONFIG_LEVEL_BG);
  if (pour_voir)
    {
      stretch_blit (pour_voir, screen, 0, 0,
		    pour_voir->w, pour_voir->h,
		    menu_real_x(x6),
		    menu_real_x(y1),
		    menu_real_x(MENU_W_LEVEL),
		    menu_real_x(MENU_W_LEVEL));
      destroy_bitmap (pour_voir);
    }
}

/*------------------------------------------------------------------*/
static void update_choose_map (DIALOG *d)
{
  static char res_buffer[30];
  int res_w,res_h;

  scare_mouse();

  sprintf (d[13].dp,"%d",CONFIG_LEVEL_MAP+1);
  my_edit_proc (MSG_DRAW, d+13, 0);

  sprintf (d[14].dp,"%d",CONFIG_LEVEL_FG+1);
  my_edit_proc (MSG_DRAW, d+14, 0);

  sprintf (d[15].dp,"%d",CONFIG_LEVEL_BG+1);
  my_edit_proc (MSG_DRAW, d+15, 0);

  d[4].d2=CONFIG_LEVEL_MAP;
  if (CONFIG_LEVEL_FG>=CHOOSE_COLOR_NUMBER)
    d[5].d2=CONFIG_LEVEL_FG-CHOOSE_COLOR_NUMBER;
  if (CONFIG_LEVEL_BG>=CHOOSE_COLOR_NUMBER)
    d[6].d2=CONFIG_LEVEL_BG-CHOOSE_COLOR_NUMBER;

  if (d[4].d2<0)
    d[4].d2=d[4].d1;
  if (d[4].d2>d[4].d1)
    d[4].d2=0;
  my_slider_proc (MSG_DRAW,d+4,0);

  if (d[5].d2<0)
    d[5].d2=d[5].d1;
  if (d[5].d2>d[5].d1)
    d[5].d2=0;
  my_slider_proc (MSG_DRAW,d+5,0);

  if (d[6].d2<0)
    d[6].d2=d[6].d1;
  if (d[6].d2>d[6].d1)
    d[6].d2=0;
  my_slider_proc (MSG_DRAW,d+6,0);

  get_map_res(CONFIG_LEVEL_MAP,&res_w,&res_h,0);
  sprintf(res_buffer,"%dx%d",res_w,res_h);
  d[16].dp=res_buffer;
  my_textbox_proc (MSG_DRAW,d+16,0);
 
  d[17].dp=get_map_readable_name(CONFIG_LEVEL_MAP,0);
  my_textbox_proc (MSG_DRAW,d+17,0);
 
  display_chosen_level ();

  unscare_mouse();
}

/*------------------------------------------------------------------*/
static int slider_map (void *dp3, int d2)
{
  DIALOG *d;

  play_click ();
  d=dp3;
  CONFIG_LEVEL_MAP=d2;

  update_choose_map (d);

  return 0;
}

/*------------------------------------------------------------------*/
static int slider_fg (void *dp3, int d2)
{
  DIALOG *d;

  play_click ();
  d=dp3;
  CONFIG_LEVEL_FG=d2+CHOOSE_COLOR_NUMBER;

  update_choose_map (d);

  return 0;
}

/*------------------------------------------------------------------*/
static int slider_bg (void *dp3, int d2)
{
  DIALOG *d;

  play_click ();
  d=dp3;
  CONFIG_LEVEL_BG=d2+CHOOSE_COLOR_NUMBER;

  update_choose_map (d);

  return 0;
}

/*------------------------------------------------------------------*/
static void box_for_choose_map (void)
{
  DIALOG d[10];
  DIALOG_PLAYER *dp;
  int i;
  int x1,x2,x3,x4,x5,x6;
  int y1,y2,y3,y4,y5,y6;

  memset(d,0,sizeof(d));

  retrieve_choose_level_xy (&x1,&x2,&x3,&x4,&x5,&x6,
			    &y1,&y2,&y3,&y4,&y5,&y6);

  d[0].x=x4;
  d[0].y=y1;
  d[0].w=MENU_W_SAMPLE;
  d[0].h=MENU_H_SAMPLE;

  d[1].x=x1;
  d[1].y=y1;
  d[1].w=MENU_W_LEVEL;
  d[1].h=MENU_W_LEVEL;

  d[2].x=x6;
  d[2].y=y1;
  d[2].w=MENU_W_LEVEL;
  d[2].h=MENU_W_LEVEL;

  d[3].x=x6;
  d[3].y=y5;
  d[3].w=MENU_W_LEVEL;
  d[3].h=MENU_H_LEVEL;

  d[4].x=x1;
  d[4].y=y4;
  d[4].w=MENU_W_LEVEL;
  d[4].h=MENU_H_LEVEL;

  d[5].x=x6;
  d[5].y=y4;
  d[5].w=MENU_W_LEVEL;
  d[5].h=MENU_H_LEVEL;
  
  for (i=0; i<6; ++i)
    {
      d[i].proc=d_box_proc;
      d[i].flags=0;
      color_one_dialog (d+i);
      menu_real_coord (d+i);
      d[i].x--;
      d[i].y--;
      d[i].w++;
      d[i].h++;
    }

  d[6].proc=NULL; /* 6 remplace par 9 pour boites des sliders */
  /* caduque depuis que my_slider fait tout tout seul */

  dp=init_dialog (d,0);
  update_dialog (dp);
  shutdown_dialog (dp);
}

/*------------------------------------------------------------------*/
int choose_map (void)
{
  int retour=0,choix=MENU_QUICK_BACK;
  int i;
  int x1,x2,x3,x4,x5,x6;
  int y1,y2,y3,y4,y5,y6;
  DIALOG d[275];
  char buf1[BUFFER_EDIT_NUMBER +1];
  char buf2[BUFFER_EDIT_NUMBER +1];
  char buf3[BUFFER_EDIT_NUMBER +1];

  memset(d,0,sizeof(d));

  buf1[0]=0;
  buf2[0]=0;
  display_back_image ();
  set_palette_for_choose_color ();
  quick_buttons (d);

  retrieve_choose_level_xy (&x1,&x2,&x3,&x4,&x5,&x6,
			    &y1,&y2,&y3,&y4,&y5,&y6);

  d[4].proc=d[5].proc=d[6].proc=my_slider_proc;
  d[4].dp=d[5].dp=d[6].dp=NULL;
  d[4].key=d[5].key=d[6].key=0;
  d[4].dp2=slider_map;
  d[5].dp2=slider_fg;
  d[6].dp2=slider_bg;
  d[4].dp3=d[5].dp3=d[6].dp3=d;
  d[4].flags=d[5].flags=d[6].flags=0;
  //#ifdef ALLEGRO_WINDOWS
  //d[4].flags=d[5].flags=d[6].flags=D_HIDDEN;
  //#endif
  d[4].d1=RAW_MAP_NUMBER-1;
  d[5].d1=d[6].d1=RAW_TEXTURE_NUMBER-1;
  d[4].d2=CONFIG_LEVEL_MAP;
  d[5].d2=CONFIG_LEVEL_FG;
  d[6].d2=CONFIG_LEVEL_BG;
  d[4].x=x4;
  d[4].y=y5;
  d[4].w=MENU_W_SAMPLE;
  d[4].h=MENU_H_LEVEL;
  d[5].x=x3;
  d[6].x=x5;
  d[5].y=d[6].y=y2;
  d[5].w=d[6].w=MENU_H_LEVEL;
  d[5].h=d[6].h=y4-y2-MENU_H_SPACE;

  for (i=7;i<13;++i)
    {
      d[i].proc=my_button_proc;
      d[i].key=0;
      d[i].flags=D_EXIT;
      d[i].w=d[i].h=MENU_H_LEVEL;
    };
  d[7].dp=d[9].dp=d[11].dp="-";
  d[8].dp=d[10].dp=d[12].dp="+";
  d[7].x=x3;
  d[7].y=d[8].y=y5;
  d[8].x=x5;
  d[9].x=d[10].x=x3;
  d[11].x=d[12].x=x5;
  d[9].y=d[11].y=y4;
  d[10].y=d[12].y=y1;

  d[13].proc=d[14].proc=d[15].proc=my_edit_proc;
  d[13].flags=d[14].flags=d[15].flags=D_EXIT;
  d[13].dp=buf1;
  d[14].dp=buf2;
  d[15].dp=buf3;
  d[13].d1=d[14].d1=d[15].d1=BUFFER_EDIT_NUMBER;
  d[13].d2=d[14].d2=d[15].d2=0;
  d[13].x=d[15].x=x6;
  d[14].x=x1;
  d[13].w=d[14].w=d[15].w=MENU_W_LEVEL;
  d[13].h=d[14].h=d[15].h=MENU_H_LEVEL;
  d[13].y=y5;
  d[14].y=d[15].y=y4;

  d[16].proc=my_textbox_proc;
  d[16].x=x1;
  d[16].y=y6;
  d[16].w=x4-x1-MENU_W_SPACE;
  d[16].h=MENU_H_LEVEL;
  d[16].flags=0;
  d[16].dp="";

  d[17].proc=my_textbox_proc;
  d[17].x=x4;
  d[17].y=y6;
  d[17].w=x6-x4+MENU_W_LEVEL;
  d[17].h=MENU_H_LEVEL;
  d[17].flags=0;
  d[17].dp="";

  for (i=4; i<18; ++i)
    {
      color_one_dialog (d+i);
      menu_real_coord (d+i);
    }

  palette_128 (d+18,
	       menu_real_x (x1),
	       menu_real_y (y3),
	       menu_real_x (MENU_W_LEVEL),
	       menu_real_y (y4-y3-MENU_H_SPACE));
  palette_128 (d+146,
	       menu_real_x (x6),
	       menu_real_y (y3),
	       menu_real_x (MENU_W_LEVEL),
	       menu_real_y (y4-y3-MENU_H_SPACE));

  box_for_choose_map ();

  d[274].proc=NULL;

  update_choose_map (d);

  while (retour==0)
    {
      choix=my_do_dialog_no_clear (d,choix);
      switch (choix)
	{
	case -1:
	case MENU_QUICK_BACK:
	  retour=1;
	  break;
	case MENU_QUICK_MAIN:
	  retour=MENU_TOP;
	  break;
	case MENU_QUICK_QUIT:
	  if (confirm_quit())
	    retour=MENU_EXIT;
	  else
	    display_back_image();
	  box_for_choose_map ();
	  update_choose_map (d);
	  break;
	case MENU_QUICK_PLAY:
	  retour=MENU_PLAY;
	  break;
	case 7:
	  d[4].d2--;
	  if (d[4].d2<0)
	    d[4].d2=d[4].d1;
	  slider_map (d[4].dp3, d[4].d2);
	  break;
	case 8:
	  d[4].d2++;
	  if (d[4].d2>d[4].d1)
	    d[4].d2=0;
	  slider_map (d[4].dp3, d[4].d2);
	  break;
	case 9:
	  d[5].d2--;
	  if (d[5].d2<0)
	    d[5].d2=d[5].d1;
	  slider_fg (d[5].dp3, d[5].d2);
	  break;
	case 10:
	  d[5].d2++;
	  if (d[5].d2>d[5].d1)
	    d[5].d2=0;
	  slider_fg (d[5].dp3, d[5].d2);
	  break;
	case 11:
	  d[6].d2--;
	  if (d[6].d2<0)
	    d[6].d2=d[6].d1;
	  slider_bg (d[6].dp3, d[6].d2);
	  break;
	case 12:
	  d[6].d2++;
	  if (d[6].d2>d[6].d1)
	    d[6].d2=0;
	  slider_bg (d[6].dp3, d[6].d2);
	  break;
	case 13:
	  i=atoi (d[13].dp)-1;
	  if (i>=0 && i<RAW_MAP_NUMBER)
	    CONFIG_LEVEL_MAP=i;
	  play_click ();
	  update_choose_map (d);
	  break;
	case 14:
	  i=atoi (d[14].dp)-1;
	  if (i>=0 && i<RAW_TEXTURE_NUMBER
	      +CHOOSE_COLOR_NUMBER)
	    CONFIG_LEVEL_FG=i;
	  play_click ();
	  update_choose_map (d);
	  break;
	case 15:
	  i=atoi (d[15].dp)-1;
	  if (i>=0 && i<RAW_TEXTURE_NUMBER
	      +CHOOSE_COLOR_NUMBER)
	    CONFIG_LEVEL_BG=i;
	  play_click ();
	  update_choose_map (d);
	  break;

	default:
	  if (choix>=18 && choix <146)
	    {
	      CONFIG_LEVEL_FG=choix-18;
	      update_choose_map (d);
	    }
	  if (choix>=146 && choix <274)
	    {
	      CONFIG_LEVEL_BG=choix-146;
	      update_choose_map (d);
	    }
	}
    }
  if (retour>0)
    retour--;

  return retour;
}



