/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : connect.c                                        */
/* contenu       : connect menu, the list of connected players      */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdio.h>
#include <string.h>

#include "back.h"
#include "base.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "help.h"
#include "menu.h"
#include "play.h"
#include "disk.h"
#include "protocol.h"
#include "sockgen.h"
#include "server.h"
#include "network.h"
#include "error.h"
#include "internet.h"
#include "connect.h"
#include "lang.h"
#include "mouse.h"
#include "log.h"
#include "thrdgen.h"

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

#define CONNECT_BUF_SIZE 100

typedef struct
{
  int sock;
  LW_TEAMSTARTINFO team_start_info[NB_TEAMS];
  int waited_teams;
  int start;
  int force_start;
  int thread_running;
  int result;
  int finished;
} LW_CONNECT_DATA;

LW_CONNECT_DATA GLOBAL_CONNECT_DATA;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

static void connect_on_server_keepalive(void *args);
static int update_connect_menu(DIALOG *d,
			       int waited_teams,
			       LW_TEAMSTARTINFO *team_start_info);
static void position_players_list (DIALOG *d);

/*------------------------------------------------------------------*/
int lw_connect_menu (int sock)
{
  DIALOG d[8];
  DIALOG_PLAYER *dp;
  int choix=4,retour=0;
  char buf_waited_teams[CONNECT_BUF_SIZE];
  char buf_connected_players[NB_TEAMS*CONNECT_BUF_SIZE];
  int first_display=1;
  int first_getinfo=1;
  LW_CONNECT_DATA *data;
  int network_error=0;
  int hide_start_button=0;

  memset(d,0,sizeof(d));
  buf_waited_teams[0]='\0';
  buf_connected_players[0]='\0';

  data=&GLOBAL_CONNECT_DATA;
  memset(data,0,sizeof(LW_CONNECT_DATA));
  data->sock=sock;
  data->waited_teams=NB_TEAMS;

  LW_NETWORK_ON=1;

  while (retour==0)
    {
      standard_big_button (d+4,0,0,1,6);
      standard_button (d+6,0,5,1,6);

      quick_buttons(d);

      d[4].proc=my_textbox_proc;
      d[5].proc=my_textbox_proc;
      position_players_list(d+5);

      d[4].dp=buf_waited_teams;
      d[5].dp=buf_connected_players;
      d[6].dp=lw_lang_string(LW_LANG_STRING_CONNECT_STARTNOW);

      if (hide_start_button)
	{
	  d[6].proc=my_textbox_proc;
	  d[6].dp=lw_lang_string(LW_LANG_STRING_CONNECT_WAITING);
	}

      d[7].proc=0;

      if (first_display)
	{
	  display_back_image();
	  first_display=0;
	}
      dp=init_dialog (d,choix);
      while (update_dialog (dp) && !data->finished)
	{
	  show_mouse(screen);
	  if (!data->thread_running && !data->finished)
	    {
	      if (!first_getinfo)
		{
		  if (data->result==0)
		    {
		      network_error=1;
		    }
		  else
		    {
		      update_connect_menu(d,
					  data->waited_teams,
					  data->team_start_info);
		    }
		}
	      data->thread_running=1;
	      if (lw_thread_start(connect_on_server_keepalive,
				  data))
		{
		  first_getinfo=0;
		}
	      else
		{
		  data->thread_running=0;
		}
	    }
	  rest(10);
	}
      choix=shutdown_dialog (dp);

      if (network_error)
	{
	  error_network_problem();
	  lw_sock_close(&(data->sock));
	  retour=1;
	}
      else 
	{
	  /*
	   * If 0 teams are waited for, then the game must start, so
	   * we simulate a key press on the "start" button.
	   */
	  if (data->waited_teams==0)
	    {
	      retour=MENU_OK;
	    }
	  else
	    {
	      switch (choix)
		{
		case -1:
		case MENU_QUICK_BACK:
		  lw_sock_close(&(data->sock));
		  retour=1;
		  break;
		case MENU_QUICK_MAIN:
		  lw_sock_close(&(data->sock));
		  retour=MENU_TOP;
		  break;
		case MENU_QUICK_QUIT:
		  lw_sock_close(&(data->sock));
		  if (confirm_quit())
		    retour=MENU_EXIT;
		  else
		    display_back_image();
		  break;
		case MENU_QUICK_PLAY:
		  /*
		   * Pressing Play or Start has the same effect here
		   * so there's no "break;"
		   */
		case 6:
		  if (data->waited_teams>0)
		    {
		      data->force_start=1;
		      hide_start_button=1;
		      display_back_image();
		    }		 
		  break;
		}
	    }
	}
    }

  while (data->thread_running)
    {
      /*
       * Here, we wait until the thread is over, it shouldn't be very 
       * long since we just wait for the server's answer
       */
      rest(100);
    }

  if (retour>0)
    retour--;

  return retour;
}

/*------------------------------------------------------------------*/
/*
 * Updates the fields of the menu
 */
static int update_connect_menu(DIALOG *d,
			       int waited_teams,
			       LW_TEAMSTARTINFO *team_start_info)
{
  int result=0;
  int i;
  char *sep;
  char buf[CONNECT_BUF_SIZE];

  sprintf(d[4].dp,"%s%d%s",
	  lw_lang_string(LW_LANG_STRING_CONNECT_WAITINGFOR),
	  waited_teams,
	  lw_lang_string(LW_LANG_STRING_CONNECT_TEAMS));

  ((char *) (d[5].dp))[0]='\0';
  for (i=0;i<NB_TEAMS;++i)
    {
      if (team_start_info[i].active)
	{
	  if (team_start_info[i].start)
	    {
	      sep="*";
	    }
	  else
	    {
	      sep="-";
	    }

	  sprintf(buf,"%d %s %s\n",
		  i+1,sep,team_start_info[i].name);
	  
	  strcat(d[5].dp,buf);
	}
    }

  scare_mouse();
  d[4].proc(MSG_DRAW,d+4,0);
  d[5].proc(MSG_DRAW,d+5,0);
  unscare_mouse();

  show_mouse(screen);

  return result;
}

/*------------------------------------------------------------------*/
/*
 * Retrieves informations from the server once all players are
 * connected. Also displays information in a dialog box.
 */
static void connect_on_server_keepalive(void *arg)
{
  int result=1;
  int i;
  LW_CONNECT_DATA *data;

  data=(LW_CONNECT_DATA *) arg;

  if (result==1)
    {
      if (!lw_protocol_waiting(data->sock,&(data->waited_teams)))
	{
	  result=0;
	}
    }

  for (i=0;i<NB_TEAMS;++i)
    {
      if (result==1)
	{
	  if (!lw_protocol_ask_teamstartinfo(data->sock,i,
					     &(data->team_start_info[i])))
	    {
	      result=0;
	    }
	}
    }

  if (result==1 && data->force_start)
    {
      if (!lw_protocol_force_start(data->sock))
	{
	  result=0;
	}
      /*
       * It's useless to keep on sending the START message, once is
       * just enough, let's save bandwidth!
       */
      data->force_start=0;
    }

  if (result==1)
    { 
      if (data->waited_teams==0)
	{
	  if (!lw_protocol_i_am_ready(data->sock))
	    {
	      result=0;
	    }
	  data->finished=1;
	}
      else
	{
	  if (!lw_protocol_next(data->sock))
	    {
	      result=0;
	    }      
	}
    }

  data->result=result;
  data->thread_running=0;
}

/*------------------------------------------------------------------*/
void position_players_list (DIALOG *d) {
  d->x=MENU_VIRTUAL_W/2-(3*MENU_W_STANDARD)/4;
  d->y=MENU_VIRTUAL_H/2-(4*MENU_H_STANDARD+3*MENU_H_SPACE)/2;
  d->w=(3*MENU_W_STANDARD)/2;
  d->h=4*MENU_H_STANDARD+3*MENU_H_SPACE;

  color_one_dialog (d);
  menu_real_coord (d);
}

