/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : advanced.c                                       */
/* contenu       : choix des options de jeu avancees                */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>

#include "advanced.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "time.h"
#include "menu.h"
#include "log.h"
#include "lang.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*------------------------------------------------------------------*/
static char *get_asm_algorithm_str(void)
{
  if (CONFIG_ASM_ALGORITHM)
    return (lw_lang_string(LW_LANG_STRING_ADVANCED_YES));
  else
    return (lw_lang_string(LW_LANG_STRING_ADVANCED_NO));
}

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int advanced_options (void)
{
  int *temp;
  DIALOG d[17];
  int i,retour=0,choix=4;
  static int y_pos[6]={0,1,2,4,6,8};

  memset(d,0,sizeof(d));

  for (i=0; i<6; ++i)
    {
      standard_button (d+i+4,0,y_pos[i],2,9);
      d[i+4].proc=my_textbox_proc;
    }
  for (i=0; i<6; ++i)
    {
      standard_button (d+i+10,1,y_pos[i],2,9);
      d[i+10].proc=my_slider_proc;
    }
  d[15].proc=my_button_proc;

  quick_buttons(d);
  d[4].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_ATTACK);
  d[5].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_DEFENSE);
  d[6].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_BASEHEALTH);
  d[7].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_WINNERHELP);
  d[8].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_CPUSTRENGTH);
  d[9].dp=lw_lang_string(LW_LANG_STRING_ADVANCED_ASMALGORITHM);
  d[10].d1=d[11].d1=d[12].d1=d[13].d1=16;
  d[14].d1=4;
  d[10].dp3=&CONFIG_FIGHTER_ATTACK;
  d[11].dp3=&CONFIG_FIGHTER_DEFENSE;
  d[12].dp3=&CONFIG_FIGHTER_NEW_HEALTH;
  d[13].dp3=&CONFIG_NUMBER_INFLUENCE;
  d[14].dp3=&CONFIG_CPU_ADVANTAGE;
  d[15].dp=get_asm_algorithm_str();
  for (i=10;i<15;++i)
    {
      d[i].dp=NULL;
      d[i].dp2=slider_int;
      temp=d[i].dp3;
      d[i].d2=*temp;
    }

#ifndef ASM
  /*
   * If no assembly code has been compiled, we disable the button
   */
  d[9].flags=D_HIDDEN;
  d[15].flags=D_HIDDEN;
#endif

  d[16].proc=0;

  while (retour==0)
    {
      choix=my_do_dialog (d,choix);
      switch (choix)
	{
	case -1:
	case MENU_QUICK_BACK:
	  retour=1;
	  break;
	case MENU_QUICK_MAIN:
	  retour=MENU_TOP;
	  break;
	case MENU_QUICK_QUIT:
	  if (confirm_quit())
	    retour=MENU_EXIT;
	  break;
	case MENU_QUICK_PLAY:
	  retour=MENU_PLAY;
	  break;
	case 15:
	  CONFIG_ASM_ALGORITHM=CONFIG_ASM_ALGORITHM ? 0 : 1;
	  d[15].dp=get_asm_algorithm_str();
	  scare_mouse();
	  my_button_proc (MSG_DRAW,d+15,0);
	  unscare_mouse();
	  break;
	}
    }

  if (retour>0)
    retour--;

  return retour;
}



