/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : lang.h                                           */
/* content       : handles language dependant stuff (locale)        */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_LANG
#define LIQUID_WAR_INCLUDE_LANG

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/* Declaration of all available languages                           */
/*------------------------------------------------------------------*/

#define LW_LANG_LANGUAGE_AUTO                     -1
#define LW_LANG_LANGUAGE_ENGLISH                   0
#define LW_LANG_LANGUAGE_FRANCAIS                  1

#define LW_LANG_NB_LANGUAGES                       2

/*------------------------------------------------------------------*/
/* Declaration of all available strings                             */
/*------------------------------------------------------------------*/

#define LW_LANG_STRING_LANGUAGE                    0

#define LW_LANG_STRING_HELP_CREDITS                1
#define LW_LANG_STRING_HELP_COPYRIGHT              2
#define LW_LANG_STRING_HELP_LICENSE                3
#define LW_LANG_STRING_HELP_VERSION                4

#define LW_LANG_STRING_MENU_PLAY                   5
#define LW_LANG_STRING_MENU_NETGAME                6
#define LW_LANG_STRING_MENU_MAP                    7
#define LW_LANG_STRING_MENU_TEAMS                  8
#define LW_LANG_STRING_MENU_OPTIONS                9
#define LW_LANG_STRING_MENU_ABOUT                 10
#define LW_LANG_STRING_MENU_EXIT                  11
#define LW_LANG_STRING_MENU_EXITDOS               12
#define LW_LANG_STRING_MENU_EXITWINDOWS           13
#define LW_LANG_STRING_MENU_EXITUNIX              14
#define LW_LANG_STRING_MENU_BACK                  15

#define LW_LANG_STRING_DIALOG_QUIT                16
#define LW_LANG_STRING_DIALOG_BACK                17
#define LW_LANG_STRING_DIALOG_PLAY                18
#define LW_LANG_STRING_DIALOG_MAIN                19

#define LW_LANG_STRING_PLAY_GETREADY              20

#define LW_LANG_STRING_NETGAME_STARTGAME          21
#define LW_LANG_STRING_NETGAME_SERVERADDR         22
#define LW_LANG_STRING_NETGAME_SERVERPORT         23
#define LW_LANG_STRING_NETGAME_SEARCH             24

#define LW_LANG_STRING_LANGUAGE_AUTO              25

#define LW_LANG_STRING_TEAM_OFF                   26
#define LW_LANG_STRING_TEAM_HUMAN                 27
#define LW_LANG_STRING_TEAM_CPU                   28

#define LW_LANG_STRING_OPTIONS_GRAPHICS           29
#define LW_LANG_STRING_OPTIONS_SOUND              30
#define LW_LANG_STRING_OPTIONS_RULES              31
#define LW_LANG_STRING_OPTIONS_SPEEDS             32
#define LW_LANG_STRING_OPTIONS_CONTROLS           33
#define LW_LANG_STRING_OPTIONS_LANGUAGE           34
#define LW_LANG_STRING_OPTIONS_DEFAULT            35

#define LW_LANG_STRING_GRAPHICS_GAME              36
#define LW_LANG_STRING_GRAPHICS_MENU              37
#define LW_LANG_STRING_GRAPHICS_ON                38
#define LW_LANG_STRING_GRAPHICS_OFF               39
#define LW_LANG_STRING_GRAPHICS_FULLSCREEN        40
#define LW_LANG_STRING_GRAPHICS_WINDOWED          41
#define LW_LANG_STRING_GRAPHICS_ADVANCED          42
#define LW_LANG_STRING_GRAPHICS_VIDEOMODE         43
#define LW_LANG_STRING_GRAPHICS_BRIGHTNESS        44
#define LW_LANG_STRING_GRAPHICS_VIEWPORTSIZE      45
#define LW_LANG_STRING_GRAPHICS_PAGEFLIPPING      46
#define LW_LANG_STRING_GRAPHICS_WAVES             47

#define LW_LANG_STRING_VOLUME_SFX                 48
#define LW_LANG_STRING_VOLUME_CLICK               49
#define LW_LANG_STRING_VOLUME_GAMEWATER           50
#define LW_LANG_STRING_VOLUME_MENUWATER           51
#define LW_LANG_STRING_VOLUME_MUSIC               52

#define LW_LANG_STRING_RULES_TIME                 53
#define LW_LANG_STRING_RULES_ADVANCED             54
#define LW_LANG_STRING_RULES_ARMYSIZE             55

#define LW_LANG_STRING_ADVANCED_ATTACK            56
#define LW_LANG_STRING_ADVANCED_DEFENSE           57
#define LW_LANG_STRING_ADVANCED_BASEHEALTH        58
#define LW_LANG_STRING_ADVANCED_WINNERHELP        59
#define LW_LANG_STRING_ADVANCED_CPUSTRENGTH       60
#define LW_LANG_STRING_ADVANCED_ASMALGORITHM      61
#define LW_LANG_STRING_ADVANCED_YES               62
#define LW_LANG_STRING_ADVANCED_NO                63

#define LW_LANG_STRING_SPEEDS_CURSOR              64
#define LW_LANG_STRING_SPEEDS_FPS                 65
#define LW_LANG_STRING_SPEEDS_NOFPSLIMIT          66
#define LW_LANG_STRING_SPEEDS_RPS                 67
#define LW_LANG_STRING_SPEEDS_NORPSLIMIT          68

#define LW_LANG_STRING_CONTROLS_JOYSTICK          69          
#define LW_LANG_STRING_CONTROLS_OFF               70
#define LW_LANG_STRING_CONTROLS_2JOYSTICKS        71
#define LW_LANG_STRING_CONTROLS_4BUTTONS          72
#define LW_LANG_STRING_CONTROLS_STANDARD          73
#define LW_LANG_STRING_CONTROLS_MOUSESENSIB       74

#define LW_LANG_STRING_ABOUT_CREDITS              75
#define LW_LANG_STRING_ABOUT_COPYRIGHT            76
#define LW_LANG_STRING_ABOUT_LICENSE              77
#define LW_LANG_STRING_ABOUT_VERSION              78

#define LW_LANG_STRING_INTERNET_REFRESH           79
#define LW_LANG_STRING_INTERNET_JOINNOW           80
#define LW_LANG_STRING_INTERNET_PORT              81
#define LW_LANG_STRING_INTERNET_PASSWORD          82
#define LW_LANG_STRING_INTERNET_YES               83
#define LW_LANG_STRING_INTERNET_NO                84
#define LW_LANG_STRING_INTERNET_UPTIME            85
#define LW_LANG_STRING_INTERNET_DAYS              86
#define LW_LANG_STRING_INTERNET_DAY               87
#define LW_LANG_STRING_INTERNET_HOURS             88
#define LW_LANG_STRING_INTERNET_MINUTES           89
#define LW_LANG_STRING_INTERNET_SECONDS           90

#define LW_LANG_STRING_WAVE_AMPLI                 91
#define LW_LANG_STRING_WAVE_NUMBER                92
#define LW_LANG_STRING_WAVE_SPEED                 93
#define LW_LANG_STRING_WAVE_WX                    94
#define LW_LANG_STRING_WAVE_HY                    95
#define LW_LANG_STRING_WAVE_WY                    96
#define LW_LANG_STRING_WAVE_HX                    97

#define LW_LANG_STRING_CONNECT_STARTNOW           98
#define LW_LANG_STRING_CONNECT_WAITING            99
#define LW_LANG_STRING_CONNECT_WAITINGFOR        100
#define LW_LANG_STRING_CONNECT_TEAMS             101

#define LW_LANG_STRING_NETPLAY_CONNECT           102
#define LW_LANG_STRING_NETPLAY_PING              103
#define LW_LANG_STRING_NETPLAY_CHECKPROGRAM      104
#define LW_LANG_STRING_NETPLAY_CHECKVERSION      105
#define LW_LANG_STRING_NETPLAY_FREETEAMS         106
#define LW_LANG_STRING_NETPLAY_RESERVETEAMS      107
#define LW_LANG_STRING_NETPLAY_SENDCONFIG        108
#define LW_LANG_STRING_NETPLAY_SENDMAP           109
#define LW_LANG_STRING_NETPLAY_WAITING           110
#define LW_LANG_STRING_NETPLAY_WHOPLAYS          111
#define LW_LANG_STRING_NETPLAY_RECVCONFIG        112
#define LW_LANG_STRING_NETPLAY_RECVMAP           113

#define LW_LANG_STRING_CODE_FPS                  114
#define LW_LANG_STRING_CODE_RPS                  115
#define LW_LANG_STRING_CODE_PERCENTCALC          116
#define LW_LANG_STRING_CODE_PERCENTDISPLAY       117
#define LW_LANG_STRING_CODE_SPREADGRADTIME       118
#define LW_LANG_STRING_CODE_MOVEARMYTIME         119
#define LW_LANG_STRING_CODE_DISPLAYTIME          120
#define LW_LANG_STRING_CODE_FLIPTIME             121
#define LW_LANG_STRING_CODE_OTHERCALCTIME        122
#define LW_LANG_STRING_CODE_GLOBALTIME           123
#define LW_LANG_STRING_CODE_STANDARDDISPLAY      124
#define LW_LANG_STRING_CODE_GRADIENT1            125
#define LW_LANG_STRING_CODE_GRADIENT2            126
#define LW_LANG_STRING_CODE_GRADIENT3            127
#define LW_LANG_STRING_CODE_GRADIENT4            128
#define LW_LANG_STRING_CODE_GRADIENT5            129
#define LW_LANG_STRING_CODE_GRADIENT6            130
#define LW_LANG_STRING_CODE_MESHSIZE             131
#define LW_LANG_STRING_CODE_MESHSTRUCTURE        132
#define LW_LANG_STRING_CODE_PAUSEOFF             133
#define LW_LANG_STRING_CODE_PAUSEON              134
#define LW_LANG_STRING_CODE_WAVEEFFECTSOFF       135
#define LW_LANG_STRING_CODE_WAVEEFFECTSON        136

#define LW_LANG_STRING_SCORE_WINNER              137

#define LW_LANG_STRING_GAME_BACKMEMFAIL          138
#define LW_LANG_STRING_GAME_DISPMEMFAIL          139
#define LW_LANG_STRING_GAME_MESHMEMFAIL          140
#define LW_LANG_STRING_GAME_AREAMEMFAIL          141
#define LW_LANG_STRING_GAME_ARMYMEMFAIL          142

#define LW_LANG_STRING_ERROR_NOTENOUGHTEAMS      143
#define LW_LANG_STRING_ERROR_NOTENOUGHBIGDATA    144
#define LW_LANG_STRING_ERROR_GRAPHICSINITFAILED  145
#define LW_LANG_STRING_ERROR_NONETWORKSUPPORT    146
#define LW_LANG_STRING_ERROR_UNABLETOCONNECT     147
#define LW_LANG_STRING_ERROR_NOTALIQUIDWARSERVER 148 
#define LW_LANG_STRING_ERROR_WRONGVERSION        149
#define LW_LANG_STRING_ERROR_NETWORKPROBLEM      150
#define LW_LANG_STRING_ERROR_CANTSENDMAP         151
#define LW_LANG_STRING_ERROR_CANTRECEIVEMAP      152
#define LW_LANG_STRING_ERROR_SERVERFULL          153

#define LW_LANG_NB_STRINGS                       154

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

extern void lw_lang_init();
extern char *lw_lang_string(int id);
extern char *lw_lang_language(int lang);
extern int lw_lang_auto();

#endif
