/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : netconf.c                                        */
/* content       : functions to transmit the conf over the network  */
/* last update   : June 30th 2001                                   */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "netconf.h"
#include "sock2gen.h"
#include "log.h"

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

/*==================================================================*/
/* types                                                            */
/*==================================================================*/

/*==================================================================*/
/* static functions declaration                                     */
/*==================================================================*/

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * Sends a config over the network
 */
int lw_netconf_send(int sock, LW_NETCONF *config)
{
  int result=0;
  char buffer[LW_SOCK_MESSAGE_SIZE];

  sprintf(buffer,"%d",
	  config->cursor_increase_speed);
  if (lw_sock_send_str(sock,buffer))
    {
      sprintf(buffer,"%d",
	      config->fighter_attack);
      if (lw_sock_send_str(sock,buffer))
	{
	  sprintf(buffer,"%d",
		  config->fighter_defense);
	  if (lw_sock_send_str(sock,buffer))
	    {
	      sprintf(buffer,"%d",
		      config->fighter_new_health);
	      if (lw_sock_send_str(sock,buffer))
		{
		  sprintf(buffer,"%d",
			  config->number_influence);
		  if (lw_sock_send_str(sock,buffer))
		    {
		      sprintf(buffer,"%d",
			      config->fighter_number);
		      if (lw_sock_send_str(sock,buffer))
			{
			  sprintf(buffer,"%d",
				  config->game_time);
			  if (lw_sock_send_str(sock,buffer))
			    {
			      sprintf(buffer,"%d",
				      config->cpu_advantage);
			      if (lw_sock_send_str(sock,buffer))
				{
				  sprintf(buffer,"%d",
					  config->asm_algorithm);
				  if (lw_sock_send_str(sock,buffer))
				    {
				      result=1;
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }
    
  return result;
}

/*------------------------------------------------------------------*/
/*
 * Receives a config from the network
 */
int lw_netconf_recv(int sock, LW_NETCONF *config)
{
  int result=0;
  char buffer[LW_SOCK_MESSAGE_SIZE];

  memset(config,0,sizeof(LW_NETCONF));

  if (lw_sock_recv_str(sock,buffer))
    {
      config->cursor_increase_speed=atoi(buffer);
      if (lw_sock_recv_str(sock,buffer))
	{
	  config->fighter_attack=atoi(buffer);
	  if (lw_sock_recv_str(sock,buffer))
	    {
	      config->fighter_defense=atoi(buffer);
	      if (lw_sock_recv_str(sock,buffer))
		{
		  config->fighter_new_health=atoi(buffer);
		  if (lw_sock_recv_str(sock,buffer))
		    {
		      config->number_influence=atoi(buffer);
		      if (lw_sock_recv_str(sock,buffer))
			{
			  config->fighter_number=atoi(buffer);
			  if (lw_sock_recv_str(sock,buffer))
			    {
			      config->game_time=atoi(buffer);
			      if (lw_sock_recv_str(sock,buffer))
				{
				  config->cpu_advantage=atoi(buffer);
				  if (lw_sock_recv_str(sock,buffer))
				    {
				      config->asm_algorithm=atoi(buffer);
				      
				      result=1;
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

  return result;
}

