/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : network.c                                        */
/* content       : various network related stuff                    */
/* last update   : may 8th 2001                                     */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "network.h"	
#include "config.h"

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

int LW_NETWORK_ON=0;
LW_WHO LW_NETWORK_INFO[NB_TEAMS];
int LW_NETWORK_ERROR_DETECTED=0;
void *LW_NETWORK_RAW_MAP=NULL;

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * Associates a color to each team 
 */
void lw_network_attribute_colors()
{
  int i,j,duplicate,color;

  for (i=0;i<NB_TEAMS;++i)
    {
      if (LW_NETWORK_INFO[i].active)
	{
	  if (LW_NETWORK_INFO[i].network)
	    {
	      /*
	       * -1 is a temporary value which will be overwritten
	       * by the _real_ value later
	       */
	      LW_NETWORK_INFO[i].color=-1;
	    }
	  else
	    {
	      LW_NETWORK_INFO[i].color=CONFIG_TEAM_COLOR[i];
	    }
	}
    }

  for (i=0;i<NB_TEAMS;++i)
    {
      if (LW_NETWORK_INFO[i].active && LW_NETWORK_INFO[i].network)
	{
	  duplicate=1;
	  while (duplicate)
	    {
	      color=(rand()%12);
	      duplicate=0;
	      for (j=0;j<NB_TEAMS;++j)
		{
		  if (LW_NETWORK_INFO[j].active && 
		      LW_NETWORK_INFO[j].color==color)
		    {
		      duplicate=1;
		    }
		}
	    }
	  LW_NETWORK_INFO[i].color=color;
	}
    }
}

/*------------------------------------------------------------------*/
/*
 * Associates a part to each team 
 */
void lw_network_attribute_parts()
{
  int i;
  static int order[NB_TEAMS]={0,5,2,3,1,4};

  for (i=0;i<NB_TEAMS;++i)
    {
      if (LW_NETWORK_INFO[i].active)
	{
	  LW_NETWORK_INFO[i].part=order[LW_NETWORK_INFO[i].server_id];
	}
    }
}
