#!/bin/sh
# 
# This is a small script usefull to create MPEG-2 videos from the video capture
# obtained by pressing F9 within the game.
# 
# It uses:
# - mogrify by ImageMagick Studio
# - mpeg2encode by the MPEG Software Simulation Group
# - transcode Thomas Ostreich"
#
# It's a very _basic_ script which will convert the lwXXXXXX.bmp files 
# generated by a video capture into an MPEG file.
#

MPEG_CODEC=$1
MPEG_FILE=$2
MPEG_WIDTH=320
MPEG_HEIGHT=240

if [ "$MPEG_FILE" == "" ] ; then
    echo "usage: $0 {mpeg2|xvid} <file.mpeg>"
else
    if touch $MPEG_FILE && rm $MPEG_FILE ; then
	case $MPEG_CODEC in
	    mpeg2)
		mogrify -verbose -format ppm -resize 640x480! lw??????.bmp
		mpeg2encode mpeg_capture_mpeg2encode.par $MPEG_FILE
		;;
	    *)
		find . -type f -a -name "lw??????.bmp" | sort > file.list
		transcode -i file.list -x imlist,null -g ${MPEG_WIDTH}x${MPEG_HEIGHT} -y $MPEG_CODEC,null -f 15 -w 180,25,10 -o $MPEG_FILE
		;;
	esac
    else
	echo "error: unable to write "$MPEG_FILE
    fi
fi

