/*
* A bunch of boxes of the same size.
*
* This works best if r/c are large and close to each other.
*
* Copyright (C) 2003, David Redick
* Released under the GNU General Public License (v2)
*/

#include "map.h"


void boxes()
{
     int r, c;
     int width, height;
     int startx, starty, endx, endy;
     int pad;


     section_size(&width, &height);
     pad = 1;

     for( r = 0; r < map.num_row; r++ )
     {
          for( c = 0; c < map.num_col; c++ )
          {
               if( rand()%2 == 0 )
               {
                    if( c == 0 )
                         startx = pad+1;
                    else
                         startx = width*c+pad;

                    if( r == 0 )
                         starty = pad+1;
                    else
                         starty = height*r+pad;

                    if( c == map.num_col-1 )
                         endx = map.width-pad-2;
                    else
                         endx = width*(c+1)-pad;

                    if( r == map.num_row-1 )
                         endy = map.height-pad-2;
                    else
                         endy = height*(r+1)-pad;

                    rectfill(map.map, startx, starty, endx, endy, 0);
               }
          }
     }

return;
}
