/*
* Copyright (C) 2003, David Redick
* Released under the GNU General Public License (v2)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "func.h"
#include "map.h"

map_t map;

/* [2] for r == 0, c == 1 */
/* the maps just look better if the ratio is the same */
int map_grid_size[MAX_MAP_GRID+1][2] =
{
     { 2, 3 },
     { 4, 6 },
     { 6, 9 },
     { 8, 12 },
     { 10, 15 },
     { 12, 18 },
     { 14, 21 },
     { 16, 24 },
     { 18, 26 },
};


/*****************************************************************************/

void init_map()
{
     int grid_size;
     char name[] = "lwmap.bmp";


     map.filename = malloc( sizeof(char) * strlen(name) );
     if( map.filename == NULL )
     {
          fprintf(stderr, "fatal error: can't malloc space for map name.\n");
          exit(EXIT_FAILURE);
     }
     strcpy(map.filename, name);

     map.width = DEFAULT_MAP_WIDTH;
     map.height = DEFAULT_MAP_HEIGHT;

     map.map = NULL;

     grid_size = rand()%MAX_MAP_GRID;
     map.num_row = map_grid_size[grid_size][0];
     map.num_col = map_grid_size[grid_size][1];

     map.color = 0; 

     map.func_id = rand()%MAX_FUNC;
     map.func = func[map.func_id].func;
}

/*****************************************************************************/

__inline__ void clear_map()
{
     clear_to_color(map.map, 255);
     /* draw outline */
     rect(map.map, 0, 0, map.width-1, map.height-1, 0);
}

/*****************************************************************************/

__inline__ void clear_invert_map()
{
     clear_to_color(map.map, 0);
}

/*****************************************************************************/
/* print map info to stdout */
/* really for debugging */

void print_map()
{
     printf("Name:     %s\n",      map.filename);
     printf("Size:     %dx%d\n",   map.width, map.height);
     printf("Row/Col:  %d/%d\n",   map.num_row, map.num_col);
     printf("Function: (%d) %s\n", map.func_id, func[map.func_id].name);
}

/*****************************************************************************/
/* get r, c from i */
__inline__ void section_rc( int *r, int *c, int i )
{
     *r = i / map.num_col;
     *c = i % map.num_col;

return;
}

/*****************************************************************************/

__inline__ void offset( int *xoffset, int *yoffset, int r, int c)
{
     *xoffset = c * (map.width / map.num_col);
     *yoffset = r * (map.height / map.num_row);

return;
}

/*****************************************************************************/

void rand_point_section( int *x, int *y, int pad )
{
     int section_width  = map.width / map.num_col;
     int section_height = map.height / map.num_row;


     /* the *2 is for the padding on both sides */
     *x = rand()%(section_width-(pad*2))+pad;
     *y = rand()%(section_height-(pad*2))+pad;

return;
}

/*****************************************************************************/

void rand_point_section_offset( int *x, int *y, int r, int c, int pad )
{
     int xoffset, yoffset;
     int section_width  = map.width / map.num_col;
     int section_height = map.height / map.num_row;

     offset(&xoffset, &yoffset, r, c);

     /* the *2 is for the padding on both sides */
     *x = rand()%(section_width-(pad*2))+pad+xoffset;
     *y = rand()%(section_height-(pad*2))+pad+yoffset;

return;
}

/*****************************************************************************/

__inline__ void section_size( int *width, int *height )
{
     *width = map.width / map.num_col;
     *height = map.height / map.num_row;

return;
}

/*****************************************************************************/

__inline__ void center_section( int *x, int *y, int r, int c )
{
     int xoffset, yoffset;
     int width, height;

     offset(&xoffset, &yoffset, r, c);
     section_size(&width, &height);

     *x = (width/2)+xoffset;
     *y = (height/2)+yoffset;

return;
}

/*****************************************************************************/
