/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a multiplayer wargame                                       */
/* Copyright (C) 1998-2004 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : random.c                                         */
/* content       : wrapper for the functions in ../utils/lwmpagen/  */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/


#include <stdio.h>
#include <allegro.h>

#include "random.h"
#include "alleg2.h"
#include "map.h"
#include "config.h"
#include "disk.h"
#include "log.h"
#include "macro.h"
#include "startup.h"
#include "init.h"
#include "exec2.h"

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

#define LW_RANDOM_RUN_DELAY 100
#define LW_RANDOM_RUN_RETRIES 50

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

void *LW_RANDOM_RAW_MAP = NULL;
int LW_RANDOM_ON = 0;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * Generates a black&white palette which is suitable for 
 * the game to handle nicely maps generated by lwmapgen. Basically
 * all we need is color 0 == black and color 2555 = white, but
 * we do a full grayscale, just to say the palette is not full of
 * garbage.
 */
static void
generate_bw_palette (PALETTE pal)
{
  int i;

  for (i = 0; i < 256; ++i)
    {
      pal[i].r = i;
      pal[i].g = i;
      pal[i].b = i;
    }
}

/*------------------------------------------------------------------*/
static void
query_min_max_map_res (int *min_w, int *min_h, int *max_w, int *max_h)
{
  int i;
  int w, h;

  *min_w = 2 << 24;
  *min_h = 2 << 24;
  *max_w = 0;
  *max_h = 0;

  for (i = 0; i < RAW_MAP_NUMBER; ++i)
    {
      lw_map_get_res (i, &w, &h, 0, 0, 0, 0);
      if (*min_w > w)
	{
	  *min_w = w;
	}
      if (*min_h > h)
	{
	  *min_h = h;
	}
      if (*max_w < w)
	{
	  *max_w = w;
	}
      if (*max_h < h)
	{
	  *max_h = h;
	}
    }

  if (*min_w < MIN_MAP_RES_W[CONFIG_MIN_MAP_RES])
    {
      *min_w = MIN_MAP_RES_W[CONFIG_MIN_MAP_RES];
    }

  if (*min_h < MIN_MAP_RES_H[CONFIG_MIN_MAP_RES])
    {
      *min_h = MIN_MAP_RES_H[CONFIG_MIN_MAP_RES];
    }

  if (*max_w - *min_w < 10)
    {
      *min_w = MIN_MAP_RES_W[2];
      *min_h = MIN_MAP_RES_H[2];
    }
  if (*max_h - *min_h < 10)
    {
      *max_w = MIN_MAP_RES_W[6];
      *max_h = MIN_MAP_RES_H[6];
    }
}

/*------------------------------------------------------------------*/
static BITMAP *
generate_bitmap ()
{
  BITMAP *bmp;
  PALETTE pal;

  char filename[LW_STARTUP_MAX_PATH_LENGTH];
  char command[LW_STARTUP_MAX_PATH_LENGTH];

  int min_w, min_h, max_w, max_h;
  int width, height;
  int ok = 0;

  query_min_max_map_res (&min_w, &min_h, &max_w, &max_h);
  width =
    min_w +
    ((((random () % 10) * (random () % 10)) % 100) * (max_w - min_w)) / 100;
  height = (width * (100 + (random () % 100))) / 200;

  LW_MACRO_SPRINTF1 (filename, "%s.bmp", tmpnam (NULL));
  LW_MACRO_SPRINTF4 (command,
		     "%s --out %s --width %d --height %d > /dev/null",
		     STARTUP_GEN_PATH, filename, width, height);

  log_print_str ("Generating random map with command: \"");
  log_print_str (command);
  log_print_str ("\"");

  ok = lw_exec2_run (STARTUP_GEN_PATH, command);
#ifdef WIN32
  {
    /*
     * Under Windows we need to wait a bit until the map generator is done
     * with generating the map, until an easy way is found to "wait until the
     * program is finished".
     */
    int i;

    for (i = 0; i < LW_RANDOM_RUN_RETRIES && !exists (filename); ++i)
      {
	rest (LW_RANDOM_RUN_DELAY);
      }
  }
#endif
  display_success (ok);

  if (ok)
    {
      bmp = load_bitmap (filename, pal);
    }
  else
    {
      bmp = NULL;
    }

  delete_file (filename);

#ifdef WIN32
  {
    /*
     * Sometimes files aren't deleted properly on Windows, so we wait
     * "a little more" just to be sure.
     */
    int i;
    
    for (i = 0; i < LW_RANDOM_RUN_RETRIES && exists (filename); ++i)
      {
	rest (LW_RANDOM_RUN_DELAY);
	delete_file (filename);
      }
  }
#endif

  return bmp;
}

/*------------------------------------------------------------------*/
int
lw_random_generate_map ()
{
  BITMAP *bmp;
  PALETTE pal;
  void *raw_map = NULL;
  int result = 0;

  bmp = generate_bitmap ();
  generate_bw_palette (pal);

  if (bmp)
    {
      raw_map = lw_map_archive_raw_bmp (bmp, pal, "lwmapgen");
    }

  if (raw_map)
    {
      if (LW_RANDOM_RAW_MAP)
	{
	  free (LW_RANDOM_RAW_MAP);
	}
      LW_RANDOM_RAW_MAP = raw_map;
      result = 1;
    }

  return result;
}
