/*
* Map info, misc functions.
*
* Copyright (C) 2003, David Redick
* Released under the GNU General Public License (v2)
*/

#ifndef LWMAPGEN_MAP_H
#define LWMAPGEN_MAP_H

#include "allegro.h"

#ifndef UNIX
#define __inline__
#endif

#define MAX_MAP_WIDTH     500
#define MIN_MAP_WIDTH     100

#define MAX_MAP_HEIGHT    500
#define MIN_MAP_HEIGHT    100

#define DEFAULT_MAP_WIDTH     320
#define DEFAULT_MAP_HEIGHT    240

#define MIN_MAP_GRID     0
#define MAX_MAP_GRID     8

extern int map_grid_size[MAX_MAP_GRID+1][2];

#define MAX_PAD     3
#define MIN_PAD     1


typedef struct
{
     char *filename;        /* should not be changed */

     int width, height;     /* should not be changed */
     BITMAP *map;

     int num_row, num_col;

     /* the color to draw with */
     int color;     /* 0 == normal, 255 == inverted */

     int func_id;
     void (*func)();
} map_t;

extern map_t map;


/* load the map with default values */
void init_map();

/* sets up the map for drawing */
__inline__ void clear_map();
__inline__ void clear_invert_map();

/* print all the map info to stdout */
/* really for debugging */
void print_map();


/*****************************************************************************/
/* Misc functions */

/*
* The default sections looks like this:
*     c 0   1   2
*  r  +---+---+---+
*  0  | 0 | 1 | 2 | <-+
*     +---+---+---+   |
*  1  | 3 | 4 | 5 | <-+- i
*     +---+---+---+
*/

/* get i from r, c */
#define section(r,c)     ( (r*map.num_col)+c )

/* get r, c from i */
__inline__ void section_rc( int *row, int *col, int i );


/* generate a pad size from min_pad to max_pad inclusive */
#define rand_pad()     ( rand()%(MAX_PAD-MIN_PAD+1)+MIN_PAD )

__inline__ void offset( int *xoffset, int *yoffset, int r, int c );

void rand_point_section( int *x, int *y, int pad );

void rand_point_section_offset( int *x, int *y, int r, int c, int pad );

__inline__ void section_size( int *width, int *height );

__inline__ void center_section( int *x, int *y, int r, int c );

/*****************************************************************************/


#endif
