/*
* Random boxes.
*
* Copyright (C) 2003, David Redick
* Released under the GNU General Public License (v2)
*/

#include <stdlib.h>
#include "map.h"


void rand_box()
{
     int r, c;
     int xoffset, yoffset;
     int pad;
     int section_width, section_height;

     /* the start is the upper left */
     int box_start_y, box_start_x;
     int box_width, box_height;


     section_size(&section_width, &section_height);

     for( r = 0; r < map.num_row; r++ )
     {
          for( c = 0; c < map.num_col; c++ )
          {
               offset(&xoffset, &yoffset, r, c);
               pad = rand_pad();


               rand_point_section( &box_start_x, &box_start_y, pad);

               /* +1 because we don't want 0 dimensions =] */
               box_width  = rand() % section_width +1;
               box_height = rand() % section_height + 1;

               /*
               * if the box goes outside the section
               * then just make the box smaller
               */
               if( box_start_x + box_width > section_width - pad )
                    box_width -= (box_start_x + box_width) - (section_width - pad);

               if( box_start_y + box_height > section_height - pad )
                    box_height -= (box_start_y + box_height) - (section_height - pad);

               rectfill(map.map, box_start_x+xoffset, box_start_y+yoffset,
                    box_start_x+box_width+xoffset, box_start_y+box_height+yoffset, 0);
          }
     }

return;
}
