/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : game.c                                           */
/* contenu       : organisation du jeu                              */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <stdlib.h>
#include <allegro.h>

#include "area.h"
#include "autoplay.h"
#include "back.h"
#include "army.h"
#include "bigdata.h"
#include "config.h"
#include "cursor.h"
#include "decal.h"
#include "disp.h"
#include "distor.h"
#include "fighter.h"
#include "game.h"
#include "grad.h"
#include "info.h"
#include "map.h"
#include "menu.h"
#include "message.h"
#include "mouse.h"
#include "move.h"
#include "pion.h"
#include "profile.h"
#include "code.h"
#include "sound.h"
#include "ticker.h"
#include "time.h"
#include "viewport.h"
#include "watchdog.h"

/*==================================================================*/
/* definitions de constantes                                        */
/*==================================================================*/

static int DISPLAY_DELAY_MIN[9]={0, 10,15,20,25,
                                    33,50,66,100};

/*==================================================================*/
/* definitions de types                                             */
/*==================================================================*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/* truc recupere depuis data.c            */

/*------------------------------------------------------------------*/
void calc_playing_teams(void)
{
 int i;

 PLAYING_TEAMS=0;

 for (i=0;i<NB_TEAMS;++i)
     if (CONFIG_TEAM_COLOR[i])
        PLAYING_TEAMS++;
}

/*------------------------------------------------------------------*/
/* gestion des actions pendant le jeu                               */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* deplacement des curseurs                                         */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
static void init_cursor_control_method (void)
{
 /* a completer pour le reseau */
 int i;

 for (i=0;i<NB_TEAMS;++i)
     {
      CURRENT_CURSOR[i].from_network=0;
      CURRENT_CURSOR[i].cpu_or_human=CONFIG_CPU_CONTROL[i];
     }
}

/*------------------------------------------------------------------*/
/* on verifie si des equipes doivent disparaitre                    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
int check_loose_team (void)
{
 int i=0,lost=0;

 while (i<PLAYING_TEAMS && !lost)
       {
        if (ACTIVE_FIGHTERS[i]==0)
           {
            eliminate_team(i);
            lost=1;
           }
        else
            ++i;
       }
 if (lost)
    {
     play_loose();
     free_info_bar();
    }
 return (lost);
}

/*------------------------------------------------------------------*/
/* initialisations du jeu                                           */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
char  *init_game (void)
{
  char *message=NULL;

  if (!message &&
      (CURRENT_AREA_BACK=create_textured_map (CONFIG_LEVEL_MAP,
                                              CONFIG_LEVEL_FG,
                                              CONFIG_LEVEL_BG))
     ==NULL)
     message="AB mem fail";

  if (!message &&
      (CURRENT_AREA_DISP=create_textured_map (CONFIG_LEVEL_MAP,
                                              CONFIG_LEVEL_FG,
                                              CONFIG_LEVEL_BG))
     ==NULL)
     message="AD mem fail";


  if (!message && create_mesh())
     message="Mesh nem fail";

  if (!message && create_game_area())
     message="Area nem fail";

  if (!message && create_army())
     message="Army nem fail";

  if (!message)
     {
     reset_mesh();
     reset_game_area();
     reset_all_cursor();
     init_cursor_control_method ();
     place_all_team();
     init_move_fighters();
     init_disp_cursor ();
     }

  return message;
}

/*------------------------------------------------------------------*/
void free_game_memory (void)
{
     free_info_bar ();
     reset_big_data ();
     if (CURRENT_AREA_DISP)
         {
          destroy_bitmap (CURRENT_AREA_DISP);
          CURRENT_AREA_DISP=0;
         }
     if (CURRENT_AREA_BACK)
         {
          destroy_bitmap (CURRENT_AREA_BACK);
          CURRENT_AREA_BACK=0;
         }
}

/*------------------------------------------------------------------*/
int blank_round(void)
{
 if (page_flip())
    {
     init_distorsion_displayer();
     display_back_image();
     rect_for_viewport ();
     disp_all_cursors();
     display_area();
     undisp_all_cursors();
     page_flip();
     display_back_image();
     rect_for_viewport ();
     clear_message();
     return 0;
    }
 else
    return -1;
}

/*------------------------------------------------------------------*/
static void fill_next_screen (void)
{
  if (GRAD_TO_DISP==0)
     {
      disp_all_cursors();
      display_area();
      undisp_all_cursors();
     }
  if (GRAD_TO_DISP>=1 && GRAD_TO_DISP<=6)
      display_gradient(GRAD_TO_DISP-1);
  if (GRAD_TO_DISP>=7 && GRAD_TO_DISP<=8)
     display_mesh(GRAD_TO_DISP-7);
}

/*------------------------------------------------------------------*/
static void logic(void)
{
      if (!PAUSE_ON)
         {
          move_all_cursors();
          apply_all_cursor();
         }
      start_profile (SPREAD_PROFILE);
      if (!PAUSE_ON)
         spread_single_gradient();
      stop_profile (SPREAD_PROFILE);

      start_profile (MOVE_PROFILE);
      if (!PAUSE_ON)
         move_fighters();
      stop_profile (MOVE_PROFILE);
      GLOBAL_CLOCK++;
}

/*------------------------------------------------------------------*/
static void display(void)
{
      watchdog_update();

      check_code();
      check_info_state();

      start_profile (DISP_PROFILE);
      fill_next_screen();
      stop_profile (DISP_PROFILE);

      display_message();

      check_loose_team();

      update_play_time();

      display_info ();

      start_profile (FLIP_PROFILE);
      page_flip ();
      stop_profile (FLIP_PROFILE);
}

/*------------------------------------------------------------------*/
int game (void)
{
 int retour=0;
 int last_display_time=get_ticker();
 int lr;

 start_play_time();
 watchdog_reset();
 reset_code();
 reset_mouse_control();
 reset_computer_path ();
 reset_all_profile();

 play_go();
 if (1/*!init_distorsion_displayer()*/)
 {
 while (  (!WATCHDOG_SCANCODE[KEY_ESC])
       && (PLAYING_TEAMS>=2)
       && (TIME_LEFT>0))
     {
      start_profile (GLOBAL_PROFILE);

      lr=0;
      do
        {
         logic();
         lr++;
        }
      while
           (CONFIG_FPS_LIMIT
           && (get_ticker() <last_display_time
                            +DISPLAY_DELAY_MIN
                            [CONFIG_FPS_LIMIT]));
      update_logic_rate(lr);

      last_display_time=get_ticker();
      display();

      stop_profile (GLOBAL_PROFILE);
     }
 }
 last_flip();

 clear_keybuf ();

 return retour;
}
