/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : main.c                                           */
/* contenu       : procedure main                                   */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "bigdata.h"
#include "config.h"
#include "disk.h"
#include "exit.h"
#include "init.h"
#include "log.h"
#include "menu.h"
#include "parser.h"
#include "sound.h"
#include "startup.h"

/*==================================================================*/
/* construct pour reduire la place d'allegro                        */
/*==================================================================*/
#ifdef ALLEGRO_DJGPP

BEGIN_GFX_DRIVER_LIST
  GFX_DRIVER_VGA
  GFX_DRIVER_MODEX
  GFX_DRIVER_VBEAF
  GFX_DRIVER_VESA2L
  GFX_DRIVER_VESA2B
  GFX_DRIVER_VESA1
END_GFX_DRIVER_LIST

BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_8
  COLOR_DEPTH_15
  COLOR_DEPTH_16
  COLOR_DEPTH_24
  COLOR_DEPTH_32
END_COLOR_DEPTH_LIST

BEGIN_DIGI_DRIVER_LIST
  DIGI_DRIVER_SB
  DIGI_DRIVER_SOUNDSCAPE
  DIGI_DRIVER_AUDIODRIVE
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

#endif

/*==================================================================*/
/* fonction principale                                              */
/*==================================================================*/

/*------------------------------------------------------------------*/
int main (int argc, char **argv)
{
 int init_success;
 int big_data_success;
 int load_dat_success;
 int load_custom_success;

 read_command_line (argc,argv);
 init_success=init_all ();
 
 big_data_success=(malloc_big_data ()!=NULL);
 log_println();
 load_dat_success=load_dat ();
 log_println();
 load_custom_success=load_custom ();
 log_println();

 if (STARTUP_STOP)
     readkey();
 #ifdef ALLEGRO_DOS
 else
     delay (500);
 #endif

 if (!init_success)
    my_exit (EXIT_CODE_INIT_FAIL);
 if (!big_data_success)
    my_exit (EXIT_CODE_BIG_DATA);
 if (!load_dat_success)
    my_exit (EXIT_CODE_LOAD_FAIL);
 if (!load_custom_success)
    my_exit (EXIT_CODE_CUSTOM_FAIL);

 order_map();
 check_config_range ();

 check_free_memory ();

 start_graphic ();
 start_water ();
 main_menu ();

 my_exit (EXIT_CODE_OK);

 return 0;
}
#ifdef ALLEGRO_WINDOWS
END_OF_MAIN() 
#endif

#ifdef ALLEGRO_UNIX
END_OF_MAIN();
#endif


