/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : watchdog.c                                       */
/* contenu       : gestion des codes secrets pendant le jeu         */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>
#include <string.h>

#include "watchdog.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

#define WATCHDOG_NUMBER 10
#define WATCHDOG_BUFFER_SIZE 1024
#define WATCHDOG_MAX_WORD 64

char WATCHDOG_ASCII[256];
char WATCHDOG_SCANCODE[128];
static int WATCHDOG_BUFFER[WATCHDOG_BUFFER_SIZE];
static int WATCHDOG_KEYS_IN_BUFFER;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void watchdog_update ()
{
 int i,n,old_pos;

 old_pos=WATCHDOG_KEYS_IN_BUFFER;

 for (i=0;i<256;++i)
     WATCHDOG_ASCII[i]=0;
 for (i=0;i<128;++i)
     WATCHDOG_SCANCODE[i]=0;

 if ( (n=(WATCHDOG_KEYS_IN_BUFFER-WATCHDOG_MAX_WORD))
      > WATCHDOG_MAX_WORD)
    {
     for (i=n;i<WATCHDOG_KEYS_IN_BUFFER;++i)
         WATCHDOG_BUFFER[i-n]=WATCHDOG_BUFFER[i];
     WATCHDOG_KEYS_IN_BUFFER-=n;
     old_pos-=n;
    }

 while (keypressed() &&
    WATCHDOG_KEYS_IN_BUFFER<WATCHDOG_BUFFER_SIZE)
        WATCHDOG_BUFFER[WATCHDOG_KEYS_IN_BUFFER++]=readkey();

 for (i=old_pos;i<WATCHDOG_KEYS_IN_BUFFER;++i)
     {
      WATCHDOG_ASCII[WATCHDOG_BUFFER[i]&0xFF]=1;
      WATCHDOG_SCANCODE[WATCHDOG_BUFFER[i]>>8]=1;
     }
}

/*------------------------------------------------------------------*/
void watchdog_reset ()
{
 WATCHDOG_KEYS_IN_BUFFER=0;

 watchdog_update();
}

/*------------------------------------------------------------------*/
int watchdog_is_keyword (char *keyword)
{
 int i,j,l,n,found=0;
 char pattern[WATCHDOG_MAX_WORD+1];

 strcpy (pattern,"ufoot");
 strcat (pattern,keyword);
 l=strlen(pattern);
 n=WATCHDOG_KEYS_IN_BUFFER-l+1;
 for (i=0; i<n && !found; ++i)
     {
      j=0;
      while (pattern[j] &&
            pattern[j]==((char) WATCHDOG_BUFFER[i+j]&0xFF))
            j++;
      found=!pattern[j];
     }

 if (found)
     WATCHDOG_BUFFER[i]|=0xFF;

 return found;
}



