/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : code.c                                           */
/* contenu       : codes et touches pendant le jeu                  */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "decal.h"
#include "message.h"
#include "profile.h"
#include "code.h"
#include "watchdog.h"

/*==================================================================*/
/* constantes                                                       */
/*==================================================================*/

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

int GRAD_TO_DISP=0;
int PAUSE_ON=0;
int CHANGED_INFO_BAR=0;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static void display_special_info (void)
{
  int global,spread,move,disp,flip;

  if (WATCHDOG_SCANCODE[KEY_F5])
     {
      global=get_profile (GLOBAL_PROFILE);
      if (global<=0)
         global=1;
      message_str_int ("Fps ", 1000/global);
     }

  if (WATCHDOG_SCANCODE[KEY_F6])
     {
      global=get_logic_rate ();
      if (global<=0)
         global=1;
      message_str_int ("Mps ", 1000/global);
     }

  if (WATCHDOG_SCANCODE[KEY_F7])
     {
      global=get_profile (GLOBAL_PROFILE);
      spread=get_profile (SPREAD_PROFILE);
      move=get_profile (MOVE_PROFILE);
      if (global<=0)
         global=1;
      message_str_int ("% calc ",
                      (100*(spread+move))/global);
     }

  if (WATCHDOG_SCANCODE[KEY_F8])
     {
      global=get_profile (GLOBAL_PROFILE);
      disp=get_profile (DISP_PROFILE);
      flip=get_profile (FLIP_PROFILE);
      if (global<=0)
         global=1;
      message_str_int ("% display ",
                      (100*(disp+flip))/global);
     }

  if (watchdog_is_keyword("speed"))
     {
      global=get_profile (GLOBAL_PROFILE);
      spread=get_profile (SPREAD_PROFILE);
      move=get_profile (MOVE_PROFILE);
      disp=get_profile (DISP_PROFILE);
      flip=get_profile (FLIP_PROFILE);

      message_str_int ("Spread grad time ",spread);
      message_str_int ("Move army time ",move);
      message_str_int ("Display time ",disp);
      message_str_int ("Flip time ",flip);
      message_str_int ("Other calc time ",
                      global-spread-move-disp-flip);
      message_str_int ("Global time ",global);
     }
}

/*------------------------------------------------------------------*/
static void check_grad_to_disp (void)
{
  char grad_codes[6];
  int i,old;

  strcpy(grad_codes,"gradn");
  old=GRAD_TO_DISP;
  for (i=0;i<=8;++i)
      {
       grad_codes[4]='0'+i;
       if (watchdog_is_keyword(grad_codes))
          GRAD_TO_DISP=i;
      }
  if (GRAD_TO_DISP>0
     && GRAD_TO_DISP<=6
     && GRAD_TO_DISP>PLAYING_TEAMS)
     GRAD_TO_DISP=0;

  if (old!=GRAD_TO_DISP)
     switch (GRAD_TO_DISP)
         {
         case 0: message_str ("Standard display");
                 break;
         case 1: message_str ("Gradient 1");
                 break;
         case 2: message_str ("Gradient 2");
                 break;
         case 3: message_str ("Gradient 3");
                 break;
         case 4: message_str ("Gradient 4");
                 break;
         case 5: message_str ("Gradient 5");
                 break;
         case 6: message_str ("Gradient 6");
                 break;
         case 7: message_str ("Mesh size");
                 break;
         case 8: message_str ("Mesh structure");
                 break;
         }
}

/*------------------------------------------------------------------*/
static void check_boolean_codes(void)
{
 if (WATCHDOG_SCANCODE[KEY_F3])
    {
    if (PAUSE_ON)
       {
        PAUSE_ON=0;
        message_str ("Pause off");
       }
    else
        {
         PAUSE_ON=1;
         message_str ("Pause on");
        }
    }
 if (WATCHDOG_SCANCODE[KEY_F4])
    {
    if (CONFIG_WAVE_ON)
       {
        CONFIG_WAVE_ON=0;
        message_str ("Wave effects off");
       }
    else
        {
         CONFIG_WAVE_ON=1;
         message_str ("Wave effects on");
        }
    }
}

/*------------------------------------------------------------------*/
void reset_code (void)
{
 GRAD_TO_DISP=0;
 PAUSE_ON=0;
}

/*------------------------------------------------------------------*/
void check_code (void)
{
 display_special_info ();
 check_grad_to_disp ();
 check_boolean_codes ();
}
