/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : disk.h                                           */
/* contenu       : chargement des donnees du fichier .dat           */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_DISK
#define LIQUID_WAR_INCLUDE_DISK

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

/*==================================================================*/
/* constantes                                                       */
/*==================================================================*/

#define SAMPLE_WATER_NUMBER     16

#define RAW_MAP_MAX_NUMBER    1024 
#define RAW_MAP_DAT_NUMBER     512

#define RAW_TEXTURE_MAX_NUMBER 1024 
#define RAW_TEXTURE_DAT_NUMBER  512

#define LANGAGE_NUMBER      2
#define HELP_TEXT_NUMBER    11

#define HELP_TEXT_MAIN      3
#define HELP_TEXT_MAP       4
#define HELP_TEXT_TEAMS     9
#define HELP_TEXT_OPTIONS   5
#define HELP_TEXT_GRAPHICS  2
#define HELP_TEXT_WAVE      10
#define HELP_TEXT_SOUND     8
#define HELP_TEXT_RULES     6
#define HELP_TEXT_ADVANCED  1
#define HELP_TEXT_ABOUT     0
#define HELP_TEXT_SCORE     7

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

extern int RAW_TEXTURE_NUMBER;
extern int RAW_MAP_NUMBER;

extern int LOADED_BACK;
extern int LOADED_TEXTURE;
extern int LOADED_SFX;
extern int LOADED_WATER;

extern SAMPLE *SAMPLE_SFX_TIME;
extern SAMPLE *SAMPLE_SFX_WIN;
extern SAMPLE *SAMPLE_SFX_GO;
extern SAMPLE *SAMPLE_SFX_CLICK;
extern SAMPLE *SAMPLE_SFX_LOOSE;

extern SAMPLE *SAMPLE_WATER[SAMPLE_WATER_NUMBER];
extern void   *RAW_MAP[RAW_MAP_MAX_NUMBER];
extern void   *RAW_MAP_ORDERED[RAW_MAP_MAX_NUMBER];
extern void   *RAW_TEXTURE[RAW_TEXTURE_MAX_NUMBER];

extern BITMAP *BACK_IMAGE;

extern FONT *BIG_FONT;
extern FONT *SMALL_FONT;
extern BITMAP *BIG_MOUSE_CURSOR;
extern BITMAP *SMALL_MOUSE_CURSOR;

extern char *HELP_TEXT[LANGAGE_NUMBER][HELP_TEXT_NUMBER];

/*==================================================================*/
/* fonctions globales                                               */
/*==================================================================*/

int load_dat (void);
int load_custom (void);
void order_map (void);

#endif
