/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : team.c                                           */
/* contenu       : choix des equipes                                */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "joystick.h"
#include "keyboard.h"
#include "menu.h"
#include "mouse.h"
#include "sound.h"
#include "team.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

static char *MENU_KEY_NAMES[]={
    "None",
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "Pad0",
    "Pad1",
    "Pad2",
    "Pad3",
    "Pad4",
    "Pad5",
    "Pad6",
    "Pad7",
    "Pad8",
    "Pad9",
    "F1",
    "F2",
    "F3",
    "F4",
    "F5",
    "F6",
    "F7",
    "F8",
    "F9",
    "F10",
    "F11",
    "F12",
    "ESC",
    "~",
    "-",
    "=",
    "Back",
    "Tab",
    "{",
    "}",
    "Enter",
    ":",
    "'",
    "\\",
    "\\",
    ",",
    ".",
    "/",
    "Space",
    "Ins",
    "Del",
    "Home",
    "End",
    "Pgup",
    "Pgdn",
    "<",
    ">",
    "/\\",
    "\\/",
    "Pad/",
    "*",
    "Pad-",
    "Pad+",
    "Pad.",
    "PadE",
    "PScr",
    "Pause",
    "LShf",
    "RShf",
    "LCnt",
    "RCnt",
    "Alt",
    "Altgr",
    "LWin",
    "RWin",
    "Menu",
    "SLock",
    "NLock",
    "CLock",
    "None",
    "None",
    "None",
    "None",
    "J1/\\",
    "J1>",
    "J1\\/",
    "J1<",
    "J1B1",
    "J1B2",
    "J1B3",
    "J1B4",
    "J2/\\",
    "J2>",
    "J2\\/",
    "J2<",
    "J2B1",
    "J2B2",
    "M/\\",
    "M>",
    "M\\/",
    "M<"
};

static char *JOYSTICK_STATES[4]=
            {"Joy off","Joy on","Joy 4b","Joy 2b"};

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static int slider_mouse (void *dp3, int d2)
{
 int *val;

 val=dp3;
 *val=d2;

 reset_mouse_control ();

 play_click ();

 return 0;
}

/*------------------------------------------------------------------*/
static int suppress_conflicting_color (int color)
{
 int i,n=-1;

 for (i=0;i<NB_TEAMS;++i)
     if (CONFIG_TEAM_COLOR[i]==color)
        CONFIG_TEAM_COLOR[n=i]=0;

 return n;
}

/*------------------------------------------------------------------*/
static char *get_key_name (int num)
{
 if (MENU_KEY_NAMES[num]!=NULL)
    return MENU_KEY_NAMES[num];
 else
     return "None";
}

/*------------------------------------------------------------------*/
static void change_key (DIALOG *d, int *val)
{
 reset_mouse_control ();
 wait_no_key();
 (*val)=wait_key_pressed();
 play_click();
 clear_keybuf();
 d->dp=get_key_name (*val);
 /*my_button_proc (MSG_DRAW, d, 0);*/
}

/*------------------------------------------------------------------*/
static void update_team_box (DIALOG *d, int number)
{
 if (CONFIG_CPU_CONTROL[number])
    d[14].dp="Cpu";
 else
     d[14].dp="Human";
 if (!CONFIG_TEAM_COLOR[number])
   {
    d[14].flags|=D_HIDDEN;
    d[0].bg=MENU_BG;
   }
 else
    {
     d[14].flags&=0xFFFFFFFF^D_HIDDEN;
     d[0].bg=128+(CONFIG_TEAM_COLOR[number]-1)*10;
    }
}

/*------------------------------------------------------------------*/
static void redraw_team_box (DIALOG *d, int number)
{
 int i;

 update_team_box(d,number);
 d_box_proc(MSG_DRAW,d,0);
 for (i=1;i<19;++i)
     my_button_proc (MSG_DRAW,d+i,0);
}

/*------------------------------------------------------------------*/
static void team_param (DIALOG *d,int x, int y, int number)
{
 int w1,w2,h,i;

 d[0].x=x;
 d[0].y=y;

 w1=(menu_real_x(MENU_W_TEAM-2*MENU_W_SPACE)+2)/14;
 w2=(menu_real_x(MENU_W_TEAM-2*MENU_W_SPACE)+2)/2;
 h=(menu_real_y(MENU_H_TEAM-2*MENU_H_SPACE)+2)/5;

 x+=2+menu_real_x(MENU_W_SPACE);
 y+=2+menu_real_y(MENU_H_SPACE);

 for (i=0;i<19;++i)
    {
      d[i].proc=my_button_proc;
      d[i].key=0;
      d[i].dp="";
      d[i].flags=D_EXIT;
      d[i].h=h-2;
      color_one_dialog (d+i);
    }

 d[0].proc=d_box_proc;
 d[0].w=menu_real_x(MENU_W_TEAM);
 d[0].h=menu_real_y(MENU_H_TEAM);

 d[1].x=x;
 d[1].y=y+h;
 d[1].w=2*w1-2;

 for (i=2;i<14;++i)
     {
      d[i].x=x+i*w1;
      d[i].y=y+h;
      d[i].w=w1-2;
      d[i].bg=128+(i-2)*10;
     }

 for (i=15;i<19;++i)
      d[i].w=w2-2;
 d[14].w=(3*w2)/2-2;

 d[14].x=x+w2/4;
 d[15].x=d[18].x=x+w2/2;
 d[16].x=x;
 d[17].x=x+w2;
 d[14].y=y;
 d[15].y=y+2*h;
 d[16].y=d[17].y=y+3*h;
 d[18].y=y+4*h;

 d[15].dp=get_key_name(CONFIG_KEY_UP[number]);
 d[16].dp=get_key_name(CONFIG_KEY_LEFT[number]);
 d[17].dp=get_key_name(CONFIG_KEY_RIGHT[number]);
 d[18].dp=get_key_name(CONFIG_KEY_DOWN[number]);

 update_team_box (d,number);
}

/*------------------------------------------------------------------*/
int choose_teams (void)
{
  int retour=0;
  DIALOG d[122];
  int i,choix=0;
  int x1,x2,x3,y1,y2;
  int button_team,button_type;

  quick_buttons(d);

  x1=(MENU_VIRTUAL_W-(3*MENU_W_TEAM+2*MENU_W_SPACE))/2;
  x2=x1+MENU_W_TEAM+MENU_W_SPACE;
  x3=x2+MENU_W_TEAM+MENU_W_SPACE;
  y1=(MENU_VIRTUAL_H-(2*MENU_H_TEAM+MENU_H_SPACE))/2;
  y2=y1+MENU_H_TEAM+MENU_H_SPACE;

  x1=menu_real_x(x1);
  x2=menu_real_x(x2);
  x3=menu_real_x(x3);
  y1=menu_real_y(y1);
  y2=menu_real_y(y2);

  standard_small_button(d+4,0,10,4,11);
  standard_small_button(d+5,2,10,4,11);
  standard_small_button(d+6,3,10,4,11);

  d[4].dp=JOYSTICK_STATES[CONFIG_JOYSTICK_ON];
  d[5].dp="Mouse";
  d[5].proc=my_textbox_proc;
  d[6].proc=my_slider_proc;
  d[6].dp=NULL;
  d[6].d1=8;
  d[6].d2=CONFIG_MOUSE_GAP;
  d[6].dp2=slider_mouse;
  d[6].dp3=&CONFIG_MOUSE_GAP;

  team_param (d+7,x1,y1,0);
  team_param (d+26,x2,y1,1);
  team_param (d+45,x3,y1,2);
  team_param (d+64,x1,y2,3);
  team_param (d+83,x2,y2,4);
  team_param (d+102,x3,y2,5);

  d[121].proc=NULL;

  set_palette_for_choose_color();
  my_set_palette();
  display_back_image ();

  while (retour==0)
         {
          choix=my_do_dialog_no_clear (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_TEAMS);
                  display_back_image ();
                  break;
             case 4:
                  CONFIG_JOYSTICK_ON++;
                  if (CONFIG_JOYSTICK_ON>=2)
                     CONFIG_JOYSTICK_ON=0;
                  d[4].dp=JOYSTICK_STATES[CONFIG_JOYSTICK_ON];
                  my_initialise_joystick();
                  my_button_proc(MSG_DRAW,d+4,0);
                  break;
             case 6:
                  break; /* utile car sinon le default est lance */
             default : button_team=(choix-7)/19;
                  button_type=(choix-7)%19;
                  switch (button_type)
                  {
                  case 14 : CONFIG_CPU_CONTROL[button_team]
                            =!CONFIG_CPU_CONTROL[button_team];
                            redraw_team_box (d+7+19*button_team,
                                            button_team);
                            break;
                  case 15 : change_key(d+choix,
                            &CONFIG_KEY_UP[button_team]);
                           break;
                  case 16 : change_key(d+choix,
                            &CONFIG_KEY_LEFT[button_team]);
                            break;
                  case 17 : change_key(d+choix,
                            &CONFIG_KEY_RIGHT[button_team]);
                            break;
                  case 18 : change_key(d+choix,
                            &CONFIG_KEY_DOWN[button_team]);
                            break;
                  default :
                   if (button_type<14)
                     {
                      i=suppress_conflicting_color (button_type-1);
                      if (i>=0)
                         redraw_team_box(d+7+19*i,i);
                      CONFIG_TEAM_COLOR[button_team]=button_type-1;
                      redraw_team_box(d+7+19*button_team,button_team);
                     }
                  }
             }
         }

 if (retour>0)
    retour--;

 return retour;
}


