/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/********************************************************************/
/* this software is protected by the GPL, see copying.txt           */
/********************************************************************/

/********************************************************************/
/* nom           : wave.c                                           */
/* contenu       : choix des options de vagues                      */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include "back.h"
#include "config.h"
#include "dialog.h"
#include "disk.h"
#include "help.h"
#include "menu.h"
#include "wave.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
static char *get_wave_effect_str(void)
{
 if (CONFIG_WAVE_ON)
    return ("On");
 else
     return ("Off");
}

/*------------------------------------------------------------------*/
int wave_options (void)
{
  int *temp;
  DIALOG d[26];
  DIALOG_PLAYER *dp;
  int i,j,k,choix=4,retour=0;

  display_back_image();
  for (i=0; i<5; ++i)
    for (j=0; j<4; ++j)
       if (i>0 || j>0)
          {
           k=i*4+j+3;
           standard_small_button (d+k,j,i+2,4,7);
           if (i>0 && j>0)
              {
               d[k].proc=my_slider_proc;
               d[k].dp=NULL;
               d[k].dp2=slider_int;
               switch (j)
                      {
                       case 1: d[k].d1=16;
                               d[k].dp3=&(CONFIG_WAVE_AMPLI[i-1]);
                               break;
                       case 2: d[k].d1=4;
                               d[k].dp3=&(CONFIG_WAVE_NUMBER[i-1]);
                               break;
                       case 3: d[k].d1=16;
                               d[k].dp3=&(CONFIG_WAVE_SPEED[i-1]);
                               break;
                      }
               temp=d[k].dp3;
               d[k].d2=*temp;
              }
           else
               d[k].proc=my_textbox_proc;
          }
  standard_button (d+23,0,0,2,7);
  standard_button (d+24,1,0,2,7);
  d[23].dp="Wave effect";
  d[24].dp=get_wave_effect_str();
  d[25].proc=NULL;

  quick_buttons(d);
  d[4].dp="Ampli";
  d[5].dp="Number";
  d[6].dp="Speed";
  d[7].dp="WX";
  d[11].dp="HY";
  d[15].dp="WY";
  d[19].dp="HX";

  display_back_image();
  while (retour==0)
        {
          dp=init_dialog (d,choix);
          while (update_dialog(dp))
              ;
          choix=shutdown_dialog (dp);
          //choix=my_do_dialog (d,choix);
          switch (choix)
            {
             case -1:
             case MENU_QUICK_BACK:
                  retour=1;
                  break;
             case MENU_QUICK_MAIN:
                  retour=MENU_TOP;
                  break;
             case MENU_QUICK_QUIT:
                  if (confirm_quit())
                    retour=MENU_EXIT;
                  else
                    display_back_image();
                  break;
             case MENU_QUICK_HELP:
                  retour=display_help (HELP_TEXT_WAVE);
                  display_back_image ();
                  break;
             case 24:
                  CONFIG_WAVE_ON=CONFIG_WAVE_ON ? 0 : 1;
                  d[24].dp=get_wave_effect_str();
                  my_button_proc (MSG_DRAW,d+24,0);
                  break;
             }
        }

  if (retour>0)
    retour--;

 return retour;
}


