/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>

#include <GL/glu.h>
#include "../liquidwar6common.h"
#include "../liquidwar6gfx.h"
#include "internal.h"

/*
 * Prepares OpenGL buffer for a new draw.
 */
void _lw6gfx_prepare_buffer(_LW6GFX_CONTEXT *context) {
  glClearColor(0.0f,0.0f,0.0f,0.0f); 
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); 
}

void lw6gfx_prepare_buffer(void *context) {
  _lw6gfx_prepare_buffer((_LW6GFX_CONTEXT *) context);
}

/*
 * Liquid War 6 uses a double buffer, this function swaps them.
 */
void _lw6gfx_swap_buffers(_LW6GFX_CONTEXT *context) {
  glFinish();
  _lw6gfx_delete_scheduled_textures(context);
  SDL_GL_SwapBuffers();
}

void lw6gfx_swap_buffers(void *context) {
  _lw6gfx_swap_buffers((_LW6GFX_CONTEXT *) context);
}

void _lw6gfx_set_render_mode_2d(_LW6GFX_CONTEXT *context) {
  if (context->render_mode!=_LW6GFX_RENDER_2D) {
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity();

    gluOrtho2D(0.0f,                             // left
	       (GLfloat) context->screen.width,  // right
	       (GLfloat) context->screen.height, // bottom
	       0.0f);                            // top

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_DEPTH);
    glDisable(GL_BLEND);
    glDisable(GL_LIGHTING);

    context->render_mode=_LW6GFX_RENDER_2D;
  }
}

void _lw6gfx_set_render_mode_2d_blend(_LW6GFX_CONTEXT *context) {
  if (context->render_mode!=_LW6GFX_RENDER_2D_BLEND) {
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity();

    gluOrtho2D(0.0f,                             // left
	       (GLfloat) context->screen.width,  // right
	       (GLfloat) context->screen.height, // bottom
	       0.0f);                            // top

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_DEPTH);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    glDisable(GL_LIGHTING);

    context->render_mode=_LW6GFX_RENDER_2D_BLEND;
  }
}

void _lw6gfx_set_render_mode_3d_map(_LW6GFX_CONTEXT *context) {
  if (context->render_mode!=_LW6GFX_RENDER_3D_MAP) {
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(context->const_data.persp_fovy,((float) context->screen.width)/((float) context->screen.height),context->const_data.persp_znear,context->const_data.persp_zfar);	
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_DEPTH);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    _lw6gfx_main_light(context);

    context->render_mode=_LW6GFX_RENDER_3D_MAP;
  }
}

void _lw6gfx_set_render_mode_3d_menu(_LW6GFX_CONTEXT *context) {
  if (context->render_mode!=_LW6GFX_RENDER_3D_MENU) {
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(context->const_data.persp_fovy,((float) context->screen.width)/((float) context->screen.height),context->const_data.persp_znear,context->const_data.persp_zfar);	
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_DEPTH);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    _lw6gfx_main_light(context);

    context->render_mode=_LW6GFX_RENDER_3D_MENU;  
  }
}


