/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SYS_H
#define LIQUIDWAR6SYS_H

/*
 * Functions in i18n.c
 */
char *lw6sys_locale_to_utf8(char *string);

/*
 * Functions in log.c
 */
extern void lw6sys_log_debug(char *module, char *fmt, ...);
extern void lw6sys_log_info(char *module, char *fmt, ...);
extern void lw6sys_log_warning(char *module, char *fmt, ...);
extern void lw6sys_log_error(char *module, char *fmt, ...);

/*
 * Functions in mem.c
 */
/*
 * The MALLOC/FREE counters are used to keep track of
 * calls to malloc/free if needed. You need to define
 * them to an (int *) if you want this feature to work.
 * Not defining them is OK but you won't get the information
 * on how many calls to malloc/free have been issued. 
 * I use this for debugging, and find it convenient.
 */
#ifndef LW6SYS_MALLOC_COUNTER
#define LW6SYS_MALLOC_COUNTER NULL
#endif
#ifndef LW6SYS_FREE_COUNTER
#define LW6SYS_FREE_COUNTER NULL
#endif
#define LW6SYS_MALLOC(SIZE) lw6sys_malloc((SIZE),__FILE__,__LINE__,LW6SYS_MALLOC_COUNTER);
#define LW6SYS_FREE(PTR) lw6sys_free((PTR),__FILE__,__LINE__,LW6SYS_FREE_COUNTER);
extern void *lw6sys_malloc(int size, char *file, int line, int *counter);
extern void lw6sys_free(void *ptr, char *file, int line, int *counter);
#define LW6SYS_CHECK_MALLOC_FREE_COUNT lw6sys_check_malloc_free_count(LW6SYS_MALLOC_COUNTER,LW6SYS_FREE_COUNTER)
extern int lw6sys_check_malloc_free_count(int *malloc_counter, int *free_counter);

/*
 * Functions in path.c
 */
extern int lw6sys_file_exists(char *filename);
extern char *lw6sys_get_conf_file(char *conf_dir, char *filename);

#endif
