;Liquid War is a multiplayer wargame.
;Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
;Liquid War homepage : http://www.ufoot.org/liquidwar
;Contact author      : ufoot@ufoot.org

(define %lw6-menu-stack
  '()
  )

(define lw6-push-menu 
  (lambda (menu)
    (set! %lw6-menu-stack (cons menu %lw6-menu-stack))
     )
  )

(define lw6-pop-menu 
  (lambda ()
    (set! %lw6-menu-stack (cdr %lw6-menu-stack))
     )
  )

(define lw6-empty-menu-stack?
  (lambda ()
    (equal? '() %lw6-menu-stack)
    )
  )

(define lw6-clear-menu
  (lambda ()
    (set! %lw6-menu-stack '())
    )
  )

(define lw6-current-menu 
  (lambda ()
    (if (lw6-empty-menu-stack?)
	'()
	(car %lw6-menu-stack)
	)
    )
  )

(define lw6-button
  (lambda (label on-enter) 
    (list
     (cons "type" 1 )
     (cons "enabled" 1 )
     (cons "value" 0 )
     (cons "selected-char" 0 )
     (cons "label" label )
     (cons "on-enter" on-enter )
     )
    )
  )

(define lw6-exit-menu 
  (lambda () 
    (list
     (cons "type" 1 )
     (cons "selected-item" 1)
     (cons "items" 
	   (list
	    (lw6-button (_ "Exit") (lambda () (lw6-pop-menu)))
	    (lw6-button (_ "Resume LW6") (lambda () (lw6-push-menu (lw6-main-menu))))
	    )
	   ) 
     )
    )
  )

(define lw6-main-menu 
  (lambda () 
    (list
     (cons "type" 1 )
     (cons "selected-item" 0)
     (cons "items" 
       (list
	(lw6-button (_ "Quick start") #f)
	(lw6-button (_ "Local game") #f)
	(lw6-button (_ "Network game") #f)
	(lw6-button (_ "Level") #f)
	(lw6-button (_ "Teams") #f)
	(lw6-button (_ "Options") #f)
	(lw6-button (_ "About") (lambda () (lw6-push-menu (lw6-about-menu))))
	)
       ) 
     )
    )
  )

(define lw6-about-menu 
  (lambda () 
    (list
     (cons "type" 1 )
     (cons "selected-item" 0)
     (cons "items" 
       (list
	(lw6-button (_ "Authors") #f)
	(lw6-button (_ "Copyright") #f)
	(lw6-button (_ "License") #f)
	(lw6-button (_ "Version") #f)
    	)
       ) 
     )
    )
  )

(define lw6-menu-action
  (lambda (action)
    (if (not (lw6-empty-menu-stack?))
	(
	 (lambda (f) (if f (f)))
	 (assoc-ref (lw6-current-menu) action))
	)
    )
  )

(define lw6-menu-pump-keys
  (lambda ()
    (let
	(
	 (key (c-lw6gfx-poll-keypress))
	 )
      (if
       key
       (begin
	 ;(display key)
	 (cond 
	  (
	   (eqv? (c-lw6gfx-keysym-esc) (assoc-ref key "sym"))
	   (lw6-pop-menu)
	   )
	  (
	   (eqv? (c-lw6gfx-keysym-enter) (assoc-ref key "sym"))
	   (lw6-menu-action "on-enter")
	   )
	  (
	   (eqv? (c-lw6gfx-keysym-quit) (assoc-ref key "sym"))
	   (lw6-clear-menu)
	   )
	  )
	 )
       )
      )
    )
  )

(define lw6-menu
  (lambda () 
    (begin 
      ;(c-lw6gfx-display-test-menu)
      ;(c-lw6gfx-display-menu (list 1 0 (list (list 1 #t 0 0 (_ "Test 1")) (list 1 #t 0 0 (_ "Test 2")))))
      (lw6-menu-pump-keys)
      (if (not (lw6-empty-menu-stack?))
	  (c-lw6gfx-display-menu (lw6-current-menu)))
      (c-lw6gfx-display-sysinfo 0 0 300 0)
      (c-lw6gfx-display-log (list (_ "titi") (_ "toto") (_ "tata")))
;      (set! key  (c-lw6gfx-poll-keypress))
;      (if key 
;	  (begin
;	    (display key)
;	    (newline)
;	    )
;	  #f
;	  )
      )
    )
  )
