/*
  Liquid War is a multiplayer wargame.
  Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War homepage : http://www.ufoot.org/liquidwar/v6
  Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../liquidwar6common.h"
#include "../liquidwar6gfx.h"
#include "internal.h"

#define SYSINFO_BUFFSIZE 1024

extern void _lw6gfx_display_sysinfo(_LW6GFX_CONTEXT *context, int fps, int rps, int bytes_in, int bytes_out) {
  char *text_list[2];
  char sysinfo[SYSINFO_BUFFSIZE];

  snprintf(sysinfo,SYSINFO_BUFFSIZE,_("%d fps, %d rps, %0.2f kb/s in, %0.2f kb/s out"), fps, rps, ((float) bytes_in)/1024.0f, ((float) bytes_out)/1024.0f); 
  text_list[0]=sysinfo;
  text_list[1]=NULL;
  _lw6gfx_draw_system_text_top_right(context, text_list);
}

extern void lw6gfx_display_sysinfo(void *context, int bps, int rps, int bytes_in, int bytes_out) {
  _lw6gfx_display_sysinfo((_LW6GFX_CONTEXT *) context, bps, rps, bytes_in, bytes_out);
}

extern void _lw6gfx_display_log(_LW6GFX_CONTEXT *context, char **log) {
  _lw6gfx_draw_system_text_bottom_left(context, log);
}

extern void lw6gfx_display_log(void *context, char **log) {
  _lw6gfx_display_log((_LW6GFX_CONTEXT *) context, log);
}

