/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar/v6
Contact author      : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "liquidwar6common.h"
#include "liquidwar6.h"
#include "liquidwar6gfx.h"

/*
 * This file should contain all global variables. Why do we
 * use global variables when we've spent so much effort to
 * get rid of them by using structures like LW6GFX_CONTEXT
 * which holds everything? Well, in current releases of LW6
 * it's acceptable to use a global variable, however what's
 * unaccceptable is to be tied to a global-variable-mode.
 * Therefore we put everything in a structure in case we'd
 * need to have several instances in memory, but for now
 * we'll use only one of these structures.
 */
void *lw6_global_gfx_context=NULL;

/*
 * Used by liquidwar6sys, but I did not like these globals
 * to be instanciated inside the shared library.
 */
int lw6_malloc_counter=0;
int lw6_free_counter=0;

