/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar/v6
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "../liquidwar6common.h"
#include "../liquidwar6sys.h"



static void log_ex(FILE *f, char *module, char *mode, char *fmt, va_list ap) {
  fprintf(f,"%s%s: %s",PACKAGE_NAME,module,mode);
  vfprintf (f, fmt, ap);
  fprintf(f,"\n");
  fflush(f);
}

/*
 * Logs a string, debug mode.
 */
void lw6sys_log_debug(char *module, char *fmt, ...) {
  if (module==NULL) {
    module="";
  }

  if (fmt!=NULL) {
    va_list ap;

    va_start(ap, fmt);
    log_ex(stdout, module, _("[debug] "), fmt, ap);
    va_end(ap);
  }
}

/*
 * Logs a string, info mode (default).
 */
void lw6sys_log_info(char *module, char *fmt, ...) {
  va_list ap;

  if (module==NULL) {
    module="";
  }

  if (fmt!=NULL) {
    va_start(ap, fmt);
    log_ex(stdout, module, "", fmt, ap);
    va_end(ap);
  }
}

/*
 * Logs a string, warning mode.
 */
void lw6sys_log_warning(char *module, char *fmt, ...) {
  if (module==NULL) {
    module="";
  }

  if (fmt!=NULL) {
    va_list ap;

    va_start(ap, fmt);
    log_ex(stderr, module, _("WARNING! "), fmt, ap);
    va_end(ap);
  }
}

/*
 * Logs a string, error mode.
 */
void lw6sys_log_error(char *module, char *fmt, ...) {
  if (module==NULL) {
    module="";
  }

  if (fmt!=NULL) {
    va_list ap;

    va_start(ap, fmt);
    log_ex(stderr, module, _("ERROR! "), fmt, ap);
    va_end(ap);
  }
}

