/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar/v6
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <locale.h>

#include "../liquidwar6common.h"
#include "../liquidwar6sys.h"

#define FILE_EXISTS_FILE "/etc/fstab"
#define MALLOC_SIZE 1048576

int lw6_malloc_counter=0;
int lw6_free_counter=0;

/*
 * Launch tests
 */
int main(int argc, char *argv[]) {
  int ret=0;
  char *ptr;

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE); 

  /*
   * log.c
   */
  lw6sys_log_debug("",_("[test] testing log_debug %s=%d"),"toto",0);
  lw6sys_log_info("",_("[test] testing log_info %s=%d"),"toto",0);
  lw6sys_log_warning("",_("[test] testing log_warning %s=%d"),"toto",0);
  lw6sys_log_error("",_("[test] testing log_error %s=%d"),"toto",0);
  
  /*
   * mem.c
   */
  lw6sys_log_info("",_("[test] testing MALLOC/FREE (%d bytes)"),MALLOC_SIZE);
  ptr=(char *) LW6SYS_MALLOC(MALLOC_SIZE*sizeof(char));
  LW6SYS_FREE(ptr);

  /*
   * path.c
   */
  lw6sys_log_info("",_("[test] testing file_exists with file \"%s\""),FILE_EXISTS_FILE); 
  if (lw6sys_file_exists(FILE_EXISTS_FILE)) {
    lw6sys_log_info("",_("[test] file \"%s\" exists"),FILE_EXISTS_FILE);
  } else {
    lw6sys_log_info("",_("[test] file \"%s\" does not exist"),FILE_EXISTS_FILE);
  }

  ret=1;

  return(!ret);
}

