/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "dyn.h"

#define TEST_DYN_TOP_LEVEL_LIB "gfx"
#define TEST_DYN_BACKEND_NAME "gl"

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"dyn-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"dyn-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"dyn-test",_("tests in \"%s\" failed"),__FUNCTION__); }

/*
 * Testing path functions
 */
static int
test_path ()
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    char *library_path;

    library_path =
      lw6dyn_path_find_backend (TEST_DYN_TOP_LEVEL_LIB,
				TEST_DYN_BACKEND_NAME);
    if (library_path && lw6sys_file_exists (library_path))
      {
	lw6sys_log (LW6SYS_LOG_DEBUG, "dyn-test",
		    _("found library \"%s/mod-%s\" in \"%s\""),
		    TEST_DYN_TOP_LEVEL_LIB, TEST_DYN_BACKEND_NAME,
		    library_path);
	LW6SYS_FREE (library_path);
      }

  }

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  ret = test_path ();

  ret = ret && lw6sys_check_malloc_free_count ();

  return (!ret);
}
