/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "gfx.h"

/*
 * This is used to stamp maps as they are created.
 * Note that there's no race condition due to the fact that this
 * is global here, in fact even when 2 processes would share
 * this sequence id, it would not matter for they would then
 * try and identify the objects in their on per-process lists,
 * structures, Guile object, whatever they use.
 */
static int seq_id = 0;

/*
 * Creates a new default game_look.
 */
LW6GFX_GAME_LOOK *
lw6gfx_game_look_new ()
{
  LW6GFX_GAME_LOOK *game_look = NULL;

  game_look = (LW6GFX_GAME_LOOK *) LW6SYS_CALLOC (sizeof (LW6GFX_GAME_LOOK));

  if (game_look)
    {
      int i;

      game_look->id = ++seq_id;

      for (i = 0; i < LW6OPT_MAX_NB_TEAMS; ++i)
	{
	  game_look->teams[i].color_id = i;
	  game_look->teams[i].cursor_shape_id = i;
	}
    }

  return game_look;
}

/*
 * Frees a game_look and all its members.
 */
void
lw6gfx_game_look_free (LW6GFX_GAME_LOOK * game_look)
{
  if (game_look)
    {
      LW6SYS_FREE (game_look);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
		  _("trying to free NULL game_look"));
    }
}


int
lw6gfx_game_look_memory_footprint (LW6GFX_GAME_LOOK * game_look)
{
  //todo
  return sizeof (LW6GFX_GAME_LOOK);
}

char *
lw6gfx_game_look_repr (LW6GFX_GAME_LOOK * game_look)
{
  char *ret = NULL;

  if (game_look)
    {
      ret = lw6sys_new_sprintf ("id=%d", game_look->id);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "game_look",
		  _("can't generate string id for NULL game_look"));
    }

  return ret;
}
