/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "gfx.h"
#include "mod-gl/mod-gl.h"

LW6SYS_ASSOC *
lw6gfx_get_backends ()
{
  LW6SYS_ASSOC *ret = NULL;

  ret = lw6sys_assoc_new (NULL);
  if (ret)
    {
      lw6sys_assoc_set (&ret, "gl", (void *) _("SDL/OpenGL"));
    }

  return ret;
}

LW6GFX_BACKEND *
lw6gfx_create_backend (char *name)
{
  LW6GFX_BACKEND *backend = NULL;

  if (name && !strcmp (name, "gl"))
    {
      backend = mod_gl_create_backend ();
    }

  if (!backend)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
		  _("graphical backend \"%s\" does not exist"), name);
    }

  return backend;
}

void
lw6gfx_destroy_backend (LW6GFX_BACKEND * backend)
{
  LW6SYS_FREE (backend);
}
